/**
 * Description: CmHouseCommentReply数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-11 上午 09:31:50
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-11   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

/**
 * CmHouseCommentReply数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-11
 * @see
 * @since 1.0
 */
public class CmHouseCommentReplyEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 回复人ID
     */

    private Integer criticId;

    /**
     * 评论来源
     */
    private Integer source;

    /**
     * 回复人名称
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String criticName;

    /**
     * 回复人手机号
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String criticPhone;

    /**
     * 回复内容
     */
    @Length(max = 500, message = "长度需要大于0且小于500")
    private String content;

    /**
     * 是否匿名
     */
    private String isAnonymous;

    public String getIsAnonymous() {
        return isAnonymous;
    }

    public void setIsAnonymous(String isAnonymous) {
        this.isAnonymous = isAnonymous;
    }

    /**
     * 所属评论ID
     */

    private Integer commentId;

    /**
     * 所属评论内容
     */
    @Length(max = 500, message = "长度需要大于0且小于500")
    private String commentContent;

    /**
     * 本人是否点赞 0:没有 1:点过赞
     */
    private Integer isPraised = 0;

    /**
     * 是否已读 0:否 1:是
     */
    private Integer isReaded;

    /**
     * 被举报次数
     */
    private Integer reportCount;

    private Integer checkStatus;

    private Integer isReplyByManager = 0;
    /**
     * 点赞人数
     */

    private Integer praiseCount;
    /**
     * 创建时间
     */

    private java.util.Date createTime;
    /**
     * 是否删除
     */

    private Integer isDeleted;
    /**
     * 是否被举报
     */

    private Integer isReported;
    /**
     * 用户头像
     */
    private String userPhoto;

    private String houseId;
    private String houseName;
    private String channel;
    private String priceScore;
    private String placeScore;
    private String trafficScore;
    private String infrastructureScore;
    private String enviromentScore;
    private String totolCommetAmount;
    private String integrationScore;
    private String criticContent;

    private String criticPictures;
    private String commentPriceScore;
    private String commentPlaceScore;
    private String commentTrafficScore;
    private String commentInfrastructureScore;
    private String commentEnvironmentScore;
    private String commentAverageScore;
    private String commentCommentDate;
    private String commentPraiseAmount;
    private String commentAmount;
    private String commentIsExcellent;
    private String StartTime;
    private String EndTime;
    private String replyId;
    private String replyIsDeleted;
    private String replyCriticId;

    private String replyCommentId;
    private String replySource;
    private String replyIsReaded;

    private int reCheckStatus;

    public String getHouseId() {
        return houseId;
    }

    public void setHouseId(String houseId) {
        this.houseId = houseId;
    }

    public String getHouseName() {
        return houseName;
    }

    public void setHouseName(String houseName) {
        this.houseName = houseName;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getPriceScore() {
        return priceScore;
    }

    public void setPriceScore(String priceScore) {
        this.priceScore = priceScore;
    }

    public String getPlaceScore() {
        return placeScore;
    }

    public void setPlaceScore(String placeScore) {
        this.placeScore = placeScore;
    }

    public String getTrafficScore() {
        return trafficScore;
    }

    public void setTrafficScore(String trafficScore) {
        this.trafficScore = trafficScore;
    }

    public String getInfrastructureScore() {
        return infrastructureScore;
    }

    public void setInfrastructureScore(String infrastructureScore) {
        this.infrastructureScore = infrastructureScore;
    }

    public String getEnviromentScore() {
        return enviromentScore;
    }

    public void setEnviromentScore(String enviromentScore) {
        this.enviromentScore = enviromentScore;
    }

    public String getTotolCommetAmount() {
        return totolCommetAmount;
    }

    public void setTotolCommetAmount(String totolCommetAmount) {
        this.totolCommetAmount = totolCommetAmount;
    }

    public String getIntegrationScore() {
        return integrationScore;
    }

    public void setIntegrationScore(String integrationScore) {
        this.integrationScore = integrationScore;
    }

    public String getCriticContent() {
        return criticContent;
    }

    public void setCriticContent(String criticContent) {
        this.criticContent = criticContent;
    }

    public String getCriticPictures() {
        return criticPictures;
    }

    public void setCriticPictures(String criticPictures) {
        this.criticPictures = criticPictures;
    }

    public String getCommentPriceScore() {
        return commentPriceScore;
    }

    public void setCommentPriceScore(String commentPriceScore) {
        this.commentPriceScore = commentPriceScore;
    }

    public String getCommentPlaceScore() {
        return commentPlaceScore;
    }

    public void setCommentPlaceScore(String commentPlaceScore) {
        this.commentPlaceScore = commentPlaceScore;
    }

    public String getCommentTrafficScore() {
        return commentTrafficScore;
    }

    public void setCommentTrafficScore(String commentTrafficScore) {
        this.commentTrafficScore = commentTrafficScore;
    }

    public String getCommentInfrastructureScore() {
        return commentInfrastructureScore;
    }

    public void setCommentInfrastructureScore(String commentInfrastructureScore) {
        this.commentInfrastructureScore = commentInfrastructureScore;
    }

    public String getCommentEnvironmentScore() {
        return commentEnvironmentScore;
    }

    public void setCommentEnvironmentScore(String commentEnvironmentScore) {
        this.commentEnvironmentScore = commentEnvironmentScore;
    }

    public String getCommentAverageScore() {
        return commentAverageScore;
    }

    public void setCommentAverageScore(String commentAverageScore) {
        this.commentAverageScore = commentAverageScore;
    }

    public String getCommentCommentDate() {
        return commentCommentDate;
    }

    public void setCommentCommentDate(String commentCommentDate) {
        this.commentCommentDate = commentCommentDate;
    }

    public String getCommentPraiseAmount() {
        return commentPraiseAmount;
    }

    public void setCommentPraiseAmount(String commentPraiseAmount) {
        this.commentPraiseAmount = commentPraiseAmount;
    }

    public String getCommentAmount() {
        return commentAmount;
    }

    public void setCommentAmount(String commentAmount) {
        this.commentAmount = commentAmount;
    }

    public String getCommentIsExcellent() {
        return commentIsExcellent;
    }

    public void setCommentIsExcellent(String commentIsExcellent) {
        this.commentIsExcellent = commentIsExcellent;
    }

    public String getStartTime() {
        return StartTime;
    }

    public void setStartTime(String startTime) {
        StartTime = startTime;
    }

    public String getEndTime() {
        return EndTime;
    }

    public void setEndTime(String endTime) {
        EndTime = endTime;
    }

    public String getReplyId() {
        return replyId;
    }

    public void setReplyId(String replyId) {
        this.replyId = replyId;
    }

    public String getReplyIsDeleted() {
        return replyIsDeleted;
    }

    public void setReplyIsDeleted(String replyIsDeleted) {
        this.replyIsDeleted = replyIsDeleted;
    }

    public String getReplyCriticId() {
        return replyCriticId;
    }

    public void setReplyCriticId(String replyCriticId) {
        this.replyCriticId = replyCriticId;
    }

    public String getReplyCommentId() {
        return replyCommentId;
    }

    public void setReplyCommentId(String replyCommentId) {
        this.replyCommentId = replyCommentId;
    }

    public String getReplySource() {
        return replySource;
    }

    public void setReplySource(String replySource) {
        this.replySource = replySource;
    }

    public String getReplyIsReaded() {
        return replyIsReaded;
    }

    public void setReplyIsReaded(String replyIsReaded) {
        this.replyIsReaded = replyIsReaded;
    }

    /**
     * 城市编号
     */

    private Integer cityId;
    /**
     * 城市名称
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String cityName;
    /**
     * 城市key
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String cityKey;

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public Integer getReportCount() {
        return reportCount;
    }

    public void setReportCount(Integer reportCount) {
        this.reportCount = reportCount;
    }

    public Integer getIsReaded() {
        return isReaded;
    }

    public void setIsReaded(Integer isReaded) {
        this.isReaded = isReaded;
    }

    public Integer getIsPraised() {

        return isPraised;
    }

    public void setIsPraised(Integer isPraised) {
        this.isPraised = isPraised;
    }

    public String getCriticPhone() {
        return criticPhone;
    }

    public void setCriticPhone(String criticPhone) {
        this.criticPhone = criticPhone;
    }

    public String getCommentContent() {
        return commentContent;
    }

    public void setCommentContent(String commentContent) {
        this.commentContent = commentContent;
    }

    public String getUserPhoto() {
        return userPhoto;
    }

    public void setUserPhoto(String userPhoto) {
        this.userPhoto = userPhoto;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public Integer getIsReported() {
        return isReported;
    }

    public void setIsReported(Integer isReported) {
        this.isReported = isReported;
    }

    public String getCityKey() {
        return cityKey;
    }

    public void setCityKey(String cityKey) {
        this.cityKey = cityKey;
    }

    /**
     * 获取评论人ID
     *
     * @return 评论人ID
     */
    public Integer getCriticId() {
        return this.criticId;
    }

    /**
     * 设置评论人ID
     *
     * @param criticId 评论人ID
     */
    public void setCriticId(Integer criticId) {
        this.criticId = criticId;
    }

    /**
     * 获取评论人名称
     *
     * @return 评论人名称
     */
    public String getCriticName() {
        return this.criticName;
    }

    /**
     * 设置评论人名称
     *
     * @param criticName 评论人名称
     */
    public void setCriticName(String criticName) {
        this.criticName = criticName;
    }

    /**
     * 获取评论内容
     *
     * @return 评论内容
     */
    public String getContent() {
        return this.content;
    }

    /**
     * 设置评论内容
     *
     * @param content 评论内容
     */
    public void setContent(String content) {
        this.content = content;
    }

    /**
     * 获取所属评论ID
     *
     * @return 所属评论ID
     */
    public Integer getCommentId() {
        return this.commentId;
    }

    /**
     * 设置所属评论ID
     *
     * @param commentId 所属评论ID
     */
    public void setCommentId(Integer commentId) {
        this.commentId = commentId;
    }

    /**
     * 获取点赞人数
     *
     * @return 点赞人数
     */
    public Integer getPraiseCount() {
        return this.praiseCount;
    }

    /**
     * 设置点赞人数
     *
     * @param praiseCount 点赞人数
     */
    public void setPraiseCount(Integer praiseCount) {
        this.praiseCount = praiseCount;
    }

    /**
     * 设置创建时间字符串格式
     *
     * @param createTime 创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取创建时间
     *
     * @return 创建时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置创建时间
     *
     * @param createTime 创建时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取是否删除
     *
     * @return 是否删除
     */
    public Integer getIsDeleted() {
        return this.isDeleted;
    }

    /**
     * 设置是否删除
     *
     * @param isDeleted 是否删除
     */
    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    /**
     * 获取城市编号
     *
     * @return 城市编号
     */
    public Integer getCityId() {
        return this.cityId;
    }

    /**
     * 设置城市编号
     *
     * @param cityId 城市编号
     */
    public void setCityId(Integer cityId) {
        this.cityId = cityId;
    }

    /**
     * 获取城市名称
     *
     * @return 城市名称
     */
    public String getCityName() {
        return this.cityName;
    }

    /**
     * 设置城市名称
     *
     * @param cityName 城市名称
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public Integer getIsReplyByManager() {
        return isReplyByManager;
    }

    public void setIsReplyByManager(Integer isReplyByManager) {
        this.isReplyByManager = isReplyByManager;
    }

    public int getReCheckStatus() {
        return reCheckStatus;
    }

    public void setReCheckStatus(int reCheckStatus) {
        this.reCheckStatus = reCheckStatus;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("CriticId",
                getCriticId()).append(
                "CriticName", getCriticName()).append("Content", getContent()).append("CommentId", getCommentId()).append(
                "PraiseCount", getPraiseCount()).append("CreateTime", getCreateTime()).append("IsDeleted",
                getIsDeleted()).append(
                "CityId", getCityId()).append("CityName", getCityName()).toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CmHouseCommentReplyEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CmHouseCommentReplyEntity other = (CmHouseCommentReplyEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }
}

