/**
 * Description: CmExchangeCode数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:13
 * <p/>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import com.house365.beans.system.DomainObject;

/**
 * CmExchangeCode数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public class CmExchangeCodeEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 商品id
     */

    private Integer goodId;

    /**
     * 兑换编码
     */
    @Length(max = 200, message = "长度需要大于0且小于200")
    private String exchangeCode;

    /**
     * 状态 0:未兑换
     */

    private Integer status;

    /**
     * 领取人id
     */

    private Integer ownerId;

    /**
     * 领取人姓名
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String ownerName;

    /**
     * 领取人电话
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String ownerPhone;

    /**
     * 有效期开始
     */

    private java.util.Date startTime;

    /**
     * 有效期结束
     */

    private java.util.Date endTime;

    /**
     * 领取时间
     */

    private java.util.Date exchangeTime;

    /**
     * 创建时间
     */

    private java.util.Date createTime;

    /**
     * 城市编号
     */

    private Integer cityId;

    /**
     * 城市名称
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String cityName;

    /**
     * 是否已经删除
     */

    private Integer isDeleted;

    /**
     * 批次
     */
    private String batch;

    /**
     * 批次ID
     */
    private Integer batchId;

    //columns END
  /*
	public CmExchangeCode(){
	}

	public CmExchangeCode(
		Integer id
	){
		this.id = id;
	}

    */

    /**
     * 设置商品id
     * @param goodId 商品id
     */
    public void setGoodId(Integer goodId) {
        this.goodId = goodId;
    }

    public Integer getBatchId() {
        return batchId;
    }

    public void setBatchId(Integer batchId) {
        this.batchId = batchId;
    }

    /**
     * 获取商品id
     * @return 商品id
     */
    public Integer getGoodId() {
        return this.goodId;
    }

    /**
     * 设置兑换编码
     * @param exchangeCode 兑换编码
     */
    public void setExchangeCode(String exchangeCode) {
        this.exchangeCode = exchangeCode;
    }

    /**
     * 获取兑换编码
     * @return 兑换编码
     */
    public String getExchangeCode() {
        return this.exchangeCode;
    }

    /**
     * 设置状态 0:未兑换
     * @param status 状态 0:未兑换
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取状态 0:未兑换
     * @return 状态 0:未兑换
     */
    public Integer getStatus() {
        return this.status;
    }

    /**
     * 设置领取人id
     * @param ownerId 领取人id
     */
    public void setOwnerId(Integer ownerId) {
        this.ownerId = ownerId;
    }

    /**
     * 获取领取人id
     * @return 领取人id
     */
    public Integer getOwnerId() {
        return this.ownerId;
    }

    /**
     * 设置领取人姓名
     * @param ownerName 领取人姓名
     */
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    /**
     * 获取领取人姓名
     * @return 领取人姓名
     */
    public String getOwnerName() {
        return this.ownerName;
    }

    /**
     * 设置领取人电话
     * @param ownerPhone 领取人电话
     */
    public void setOwnerPhone(String ownerPhone) {
        this.ownerPhone = ownerPhone;
    }

    /**
     * 获取领取人电话
     * @return 领取人电话
     */
    public String getOwnerPhone() {
        return this.ownerPhone;
    }

    /**
     * 设置有效期开始
     * @param startTime 有效期开始
     */
    public void setStartTime(java.util.Date startTime) {
        this.startTime = startTime;
    }

    /**
     * 设置有效期开始字符串格式
     * @param startTime 有效期开始
     */
    public void setStartTimeStr(String startTime) {
        if (!com.house365.web.util.StringUtils.isBlank(startTime)) {
            try {
                this.startTime = java.text.DateFormat.getDateTimeInstance().parse(startTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取有效期开始
     * @return 有效期开始
     */
    public java.util.Date getStartTime() {
        return this.startTime;
    }

    /**
     * 设置有效期结束
     * @param endTime 有效期结束
     */
    public void setEndTime(java.util.Date endTime) {
        this.endTime = endTime;
    }

    /**
     * 设置有效期结束字符串格式
     * @param endTime 有效期结束
     */
    public void setEndTimeStr(String endTime) {
        if (!com.house365.web.util.StringUtils.isBlank(endTime)) {
            try {
                this.endTime = java.text.DateFormat.getDateTimeInstance().parse(endTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取有效期结束
     * @return 有效期结束
     */
    public java.util.Date getEndTime() {
        return this.endTime;
    }

    /**
     * 设置领取时间
     * @param exchangeTime 领取时间
     */
    public void setExchangeTime(java.util.Date exchangeTime) {
        this.exchangeTime = exchangeTime;
    }

    /**
     * 设置领取时间字符串格式
     * @param exchangeTime 领取时间
     */
    public void setExchangeTimeStr(String exchangeTime) {
        if (!com.house365.web.util.StringUtils.isBlank(exchangeTime)) {
            try {
                this.exchangeTime = java.text.DateFormat.getDateTimeInstance().parse(exchangeTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取领取时间
     * @return 领取时间
     */
    public java.util.Date getExchangeTime() {
        return this.exchangeTime;
    }

    /**
     * 设置创建时间
     * @param createTime 创建时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置创建时间字符串格式
     * @param createTime 创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取创建时间
     * @return 创建时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置城市编号
     * @param cityId 城市编号
     */
    public void setCityId(Integer cityId) {
        this.cityId = cityId;
    }

    /**
     * 获取城市编号
     * @return 城市编号
     */
    public Integer getCityId() {
        return this.cityId;
    }

    /**
     * 设置城市名称
     * @param cityName 城市名称
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /**
     * 获取城市名称
     * @return 城市名称
     */
    public String getCityName() {
        return this.cityName;
    }

    /**
     * 设置是否已经删除
     * @param isDeleted 是否已经删除
     */
    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    /**
     * 获取是否已经删除
     * @return 是否已经删除
     */
    public Integer getIsDeleted() {
        return this.isDeleted;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("GoodId",
                                                                                                      getGoodId()).append(
            "ExchangeCode", getExchangeCode()).append("Status", getStatus()).append("OwnerId", getOwnerId()).append(
            "OwnerName", getOwnerName()).append("OwnerPhone", getOwnerPhone()).append("StartTime",
                                                                                      getStartTime()).append("EndTime",
                                                                                                             getEndTime()).append(
            "ExchangeTime", getExchangeTime()).append("CreateTime", getCreateTime()).append("CityId",
                                                                                            getCityId()).append(
            "CityName", getCityName()).append("IsDeleted", getIsDeleted()).toString();
    }

    /**
     * 获取hash码
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if (obj instanceof CmExchangeCodeEntity == false)
            return false;
        if (this == obj)
            return true;
        CmExchangeCodeEntity other = (CmExchangeCodeEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }
}

