/**
 * Description: CmExchangeCodeBatch数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-11-03 下午 17:36:18
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-11-03   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import javax.validation.constraints.*;
import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * CmExchangeCodeBatch数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-11-03
 * @see
 * @since 1.0
 */
public class CmExchangeCodeBatchEntity extends DomainObject{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	//可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
	//columns START
	/**
	 * 商品id
	 */
	
	private Integer goodId;
	
	/**
	 * 文件名
	 */
	@Length(max=200, message="长度需要大于0且小于200")
	private String fileName;
	
	/**
	 * 创建人ID
	 */
	
	private Integer createrId;
	
	/**
	 * 创建人姓名
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String createrName;
	
	/**
	 * 有效期开始
	 */
	
	private java.util.Date startTime;
	
	/**
	 * 有效期结束
	 */
	
	private java.util.Date endTime;
	
	/**
	 * 创建时间
	 */
	
	private java.util.Date createTime;
	
	/**
	 * 城市编号
	 */
	
	private Integer cityId;
	
	/**
	 * 城市代码
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String cityKey;
	
	/**
	 * 城市名称
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String cityName;
	
	/**
	 * 是否已经删除
	 */
	
	private Integer isDeleted;
	
	//columns END
	/*
	public CmExchangeCodeBatch(){
	}

	public CmExchangeCodeBatch(
		Integer id
	){
		this.id = id;
	}

    */

	/**
	 * 设置商品id
	 * @param goodId 商品id
	 */
	public void setGoodId(Integer goodId) {
		this.goodId = goodId;
	}

	/**
	 * 获取商品id
	 * @return 商品id
	 */
	public Integer getGoodId() {
		return this.goodId;
	}

	/**
	 * 设置文件名
	 * @param fileName 文件名
	 */
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	/**
	 * 获取文件名
	 * @return 文件名
	 */
	public String getFileName() {
		return this.fileName;
	}

	/**
	 * 设置创建人ID
	 * @param createrId 创建人ID
	 */
	public void setCreaterId(Integer createrId) {
		this.createrId = createrId;
	}

	/**
	 * 获取创建人ID
	 * @return 创建人ID
	 */
	public Integer getCreaterId() {
		return this.createrId;
	}

	/**
	 * 设置创建人姓名
	 * @param createrName 创建人姓名
	 */
	public void setCreaterName(String createrName) {
		this.createrName = createrName;
	}

	/**
	 * 获取创建人姓名
	 * @return 创建人姓名
	 */
	public String getCreaterName() {
		return this.createrName;
	}

	/**
	 * 设置有效期开始
	 * @param startTime 有效期开始
	 */
	public void setStartTime(java.util.Date startTime) {
		this.startTime = startTime;
	}

	/**
	 * 设置有效期开始字符串格式
	 * @param startTime 有效期开始
	 */
	public void setStartTimeStr(String startTime) {
		if (!com.house365.web.util.StringUtils.isBlank(startTime)) {
			try {
				this.startTime = java.text.DateFormat.getDateTimeInstance().parse(startTime);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取有效期开始
	 * @return 有效期开始
	 */
	public java.util.Date getStartTime() {
		return this.startTime;
	}

	/**
	 * 设置有效期结束
	 * @param endTime 有效期结束
	 */
	public void setEndTime(java.util.Date endTime) {
		this.endTime = endTime;
	}

	/**
	 * 设置有效期结束字符串格式
	 * @param endTime 有效期结束
	 */
	public void setEndTimeStr(String endTime) {
		if (!com.house365.web.util.StringUtils.isBlank(endTime)) {
			try {
				this.endTime = java.text.DateFormat.getDateTimeInstance().parse(endTime);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取有效期结束
	 * @return 有效期结束
	 */
	public java.util.Date getEndTime() {
		return this.endTime;
	}

	/**
	 * 设置创建时间
	 * @param createTime 创建时间
	 */
	public void setCreateTime(java.util.Date createTime) {
		this.createTime = createTime;
	}

	/**
	 * 设置创建时间字符串格式
	 * @param createTime 创建时间
	 */
	public void setCreateTimeStr(String createTime) {
		if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
			try {
				this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取创建时间
	 * @return 创建时间
	 */
	public java.util.Date getCreateTime() {
		return this.createTime;
	}

	/**
	 * 设置城市编号
	 * @param cityId 城市编号
	 */
	public void setCityId(Integer cityId) {
		this.cityId = cityId;
	}

	/**
	 * 获取城市编号
	 * @return 城市编号
	 */
	public Integer getCityId() {
		return this.cityId;
	}

	/**
	 * 设置城市代码
	 * @param cityKey 城市代码
	 */
	public void setCityKey(String cityKey) {
		this.cityKey = cityKey;
	}

	/**
	 * 获取城市代码
	 * @return 城市代码
	 */
	public String getCityKey() {
		return this.cityKey;
	}

	/**
	 * 设置城市名称
	 * @param cityName 城市名称
	 */
	public void setCityName(String cityName) {
		this.cityName = cityName;
	}

	/**
	 * 获取城市名称
	 * @return 城市名称
	 */
	public String getCityName() {
		return this.cityName;
	}

	/**
	 * 设置是否已经删除
	 * @param isDeleted 是否已经删除
	 */
	public void setIsDeleted(Integer isDeleted) {
		this.isDeleted = isDeleted;
	}

	/**
	 * 获取是否已经删除
	 * @return 是否已经删除
	 */
	public Integer getIsDeleted() {
		return this.isDeleted;
	}

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("Id",getId())
			.append("GoodId",getGoodId())
			.append("FileName",getFileName())
			.append("CreaterId",getCreaterId())
			.append("CreaterName",getCreaterName())
			.append("StartTime",getStartTime())
			.append("EndTime",getEndTime())
			.append("CreateTime",getCreateTime())
			.append("CityId",getCityId())
			.append("CityKey",getCityKey())
			.append("CityName",getCityName())
			.append("IsDeleted",getIsDeleted())
			.toString();
	}

	/**
	 * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
	 * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof CmExchangeCodeBatchEntity == false) return false;
		if(this == obj) return true;
		CmExchangeCodeBatchEntity other = (CmExchangeCodeBatchEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

