/**
 * Description: CmDeliveryAddress数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:12
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import javax.validation.constraints.*;
import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * CmDeliveryAddress数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public class CmDeliveryAddressEntity extends DomainObject{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	//可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
	//columns START
	/**
	 * 用户
	 */
	
	private Integer userId;
	
	/**
	 * 用户姓名
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String userName;
	
	/**
	 * 接收人电话
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String receiverPhone;
	
	/**
	 * 接收人姓名
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String receiverName;
	
	/**
	 * 送货地区
	 */
	@Length(max=100, message="长度需要大于0且小于100")
	private String deliverPosition;
	
	/**
	 * 送货详细地址
	 */
	@Length(max=200, message="长度需要大于0且小于200")
	private String deliverDetailAddress;
	
	/**
	 * 邮编
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String zipCode;
	
	/**
	 * 是否删除 0:未删除 1:已删除
	 */
	
	private Integer isDeleted;
	
	//columns END
	/*
	public CmDeliveryAddress(){
	}

	public CmDeliveryAddress(
		Integer id
	){
		this.id = id;
	}

    */

	/**
	 * 设置用户
	 * @param userId 用户
	 */
	public void setUserId(Integer userId) {
		this.userId = userId;
	}

	/**
	 * 获取用户
	 * @return 用户
	 */
	public Integer getUserId() {
		return this.userId;
	}

	/**
	 * 设置用户姓名
	 * @param userName 用户姓名
	 */
	public void setUserName(String userName) {
		this.userName = userName;
	}

	/**
	 * 获取用户姓名
	 * @return 用户姓名
	 */
	public String getUserName() {
		return this.userName;
	}

	/**
	 * 设置接收人电话
	 * @param receiverPhone 接收人电话
	 */
	public void setReceiverPhone(String receiverPhone) {
		this.receiverPhone = receiverPhone;
	}

	/**
	 * 获取接收人电话
	 * @return 接收人电话
	 */
	public String getReceiverPhone() {
		return this.receiverPhone;
	}

	/**
	 * 设置接收人姓名
	 * @param receiverName 接收人姓名
	 */
	public void setReceiverName(String receiverName) {
		this.receiverName = receiverName;
	}

	/**
	 * 获取接收人姓名
	 * @return 接收人姓名
	 */
	public String getReceiverName() {
		return this.receiverName;
	}

	/**
	 * 设置送货地区
	 * @param deliverPosition 送货地区
	 */
	public void setDeliverPosition(String deliverPosition) {
		this.deliverPosition = deliverPosition;
	}

	/**
	 * 获取送货地区
	 * @return 送货地区
	 */
	public String getDeliverPosition() {
		return this.deliverPosition;
	}

	/**
	 * 设置送货详细地址
	 * @param deliverDetailAddress 送货详细地址
	 */
	public void setDeliverDetailAddress(String deliverDetailAddress) {
		this.deliverDetailAddress = deliverDetailAddress;
	}

	/**
	 * 获取送货详细地址
	 * @return 送货详细地址
	 */
	public String getDeliverDetailAddress() {
		return this.deliverDetailAddress;
	}

	/**
	 * 设置邮编
	 * @param zipCode 邮编
	 */
	public void setZipCode(String zipCode) {
		this.zipCode = zipCode;
	}

	/**
	 * 获取邮编
	 * @return 邮编
	 */
	public String getZipCode() {
		return this.zipCode;
	}

	/**
	 * 设置是否删除 0:未删除 1:已删除
	 * @param isDeleted 是否删除 0:未删除 1:已删除
	 */
	public void setIsDeleted(Integer isDeleted) {
		this.isDeleted = isDeleted;
	}

	/**
	 * 获取是否删除 0:未删除 1:已删除
	 * @return 是否删除 0:未删除 1:已删除
	 */
	public Integer getIsDeleted() {
		return this.isDeleted;
	}

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("Id",getId())
			.append("UserId",getUserId())
			.append("UserName",getUserName())
			.append("ReceiverPhone",getReceiverPhone())
			.append("ReceiverName",getReceiverName())
			.append("DeliverPosition",getDeliverPosition())
			.append("DeliverDetailAddress",getDeliverDetailAddress())
			.append("ZipCode",getZipCode())
			.append("IsDeleted",getIsDeleted())
			.toString();
	}

	/**
	 * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
	 * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof CmDeliveryAddressEntity == false) return false;
		if(this == obj) return true;
		CmDeliveryAddressEntity other = (CmDeliveryAddressEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

