/**
 * Description: CmCreditRecord数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-14 上午 09:30:51
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import javax.validation.constraints.*;
import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * CmCreditRecord数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-14
 * @see
 * @since 1.0
 */
public class CmCreditRecordEntity extends DomainObject{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	//可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
	//columns START
	/**
	 * 用户id
	 */
	
	private Integer userId;
	
	/**
	 * 用户昵称
	 */
	@Length(max=100, message="长度需要大于0且小于100")
	private String userName;
	
	/**
	 * 用户手机号
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String userPhone;
	
	/**
	 * 积分规则编号
	 */
	
	private Integer ruleId;
	
	/**
	 * 积分规则名称
	 */
	@Length(max=50, message="长度需要大于0且小于50")
	private String ruleName;
	
	/**
	 * 评论ID
	 */
	
	private Integer commentId;
	
	/**
	 * 回复ID
	 */
	
	private Integer replyId;
	
	/**
	 * 商品id
	 */
	
	private Integer goodsId;
	
	/**
	 * 商品名称
	 */
	@Length(max=100, message="长度需要大于0且小于100")
	private String goodsName;
	
	/**
	 * 商品数量
	 */
	private int goodsAmount;
	
	/**
	 * 订单ID
	 */
	
	private Integer orderId;
	
	/**
	 * 积分数量
	 */
	
	private Integer amount;
	
	/**
	 * 积分余额
	 */
	
	private Integer remainingAmount;
	
	/**
	 * 发生时间
	 */
	
	private java.util.Date happenTime;
	
	/**
	 * 城市编号
	 */
	
	private Integer cityId;
	
	/**
	 * 通用记录ID
	 */
	private Integer commonId;
	
	/**
	 * 城市名称
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String cityName;
	
	//columns END
	/*
	public CmCreditRecord(){
	}

	public CmCreditRecord(
		Integer id
	){
		this.id = id;
	}

    */

	/**
	 * 设置用户id
	 * @param userId 用户id
	 */
	public void setUserId(Integer userId) {
		this.userId = userId;
	}

	public Integer getCommonId() {
        return commonId;
    }

    public void setCommonId(Integer commonId) {
        this.commonId = commonId;
    }

    /**
	 * 获取用户id
	 * @return 用户id
	 */
	public Integer getUserId() {
		return this.userId;
	}

	/**
	 * 设置用户昵称
	 * @param userName 用户昵称
	 */
	public void setUserName(String userName) {
		this.userName = userName;
	}

	/**
	 * 获取用户昵称
	 * @return 用户昵称
	 */
	public String getUserName() {
		return this.userName;
	}

	/**
	 * 设置用户手机号
	 * @param userPhone 用户手机号
	 */
	public void setUserPhone(String userPhone) {
		this.userPhone = userPhone;
	}

	/**
	 * 获取用户手机号
	 * @return 用户手机号
	 */
	public String getUserPhone() {
		return this.userPhone;
	}

	/**
	 * 设置积分规则编号
	 * @param ruleId 积分规则编号
	 */
	public void setRuleId(Integer ruleId) {
		this.ruleId = ruleId;
	}

	/**
	 * 获取积分规则编号
	 * @return 积分规则编号
	 */
	public Integer getRuleId() {
		return this.ruleId;
	}

	/**
	 * 设置积分规则名称
	 * @param ruleName 积分规则名称
	 */
	public void setRuleName(String ruleName) {
		this.ruleName = ruleName;
	}

	/**
	 * 获取积分规则名称
	 * @return 积分规则名称
	 */
	public String getRuleName() {
		return this.ruleName;
	}

	/**
	 * 设置评论ID
	 * @param commentId 评论ID
	 */
	public void setCommentId(Integer commentId) {
		this.commentId = commentId;
	}

	/**
	 * 获取评论ID
	 * @return 评论ID
	 */
	public Integer getCommentId() {
		return this.commentId;
	}

	/**
	 * 设置回复ID
	 * @param replyId 回复ID
	 */
	public void setReplyId(Integer replyId) {
		this.replyId = replyId;
	}

	/**
	 * 获取回复ID
	 * @return 回复ID
	 */
	public Integer getReplyId() {
		return this.replyId;
	}

	/**
	 * 设置商品id
	 * @param goodsId 商品id
	 */
	public void setGoodsId(Integer goodsId) {
		this.goodsId = goodsId;
	}

	/**
	 * 获取商品id
	 * @return 商品id
	 */
	public Integer getGoodsId() {
		return this.goodsId;
	}

	/**
	 * 设置商品名称
	 * @param goodsName 商品名称
	 */
	public void setGoodsName(String goodsName) {
		this.goodsName = goodsName;
	}

	/**
	 * 获取商品名称
	 * @return 商品名称
	 */
	public String getGoodsName() {
		return this.goodsName;
	}

	/**
	 * 设置订单ID
	 * @param orderId 订单ID
	 */
	public void setOrderId(Integer orderId) {
		this.orderId = orderId;
	}

	/**
	 * 获取订单ID
	 * @return 订单ID
	 */
	public Integer getOrderId() {
		return this.orderId;
	}

	/**
	 * 设置积分数量
	 * @param amount 积分数量
	 */
	public void setAmount(Integer amount) {
		this.amount = amount;
	}

	/**
	 * 获取积分数量
	 * @return 积分数量
	 */
	public Integer getAmount() {
		return this.amount;
	}

	/**
	 * 设置积分余额
	 * @param remainingAmount 积分余额
	 */
	public void setRemainingAmount(Integer remainingAmount) {
		this.remainingAmount = remainingAmount;
	}

	/**
	 * 获取积分余额
	 * @return 积分余额
	 */
	public Integer getRemainingAmount() {
		return this.remainingAmount;
	}

	/**
	 * 设置发生时间
	 * @param happenTime 发生时间
	 */
	public void setHappenTime(java.util.Date happenTime) {
		this.happenTime = happenTime;
	}

	/**
	 * 设置发生时间字符串格式
	 * @param happenTime 发生时间
	 */
	public void setHappenTimeStr(String happenTime) {
		if (!com.house365.web.util.StringUtils.isBlank(happenTime)) {
			try {
				this.happenTime = java.text.DateFormat.getDateTimeInstance().parse(happenTime);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取发生时间
	 * @return 发生时间
	 */
	public java.util.Date getHappenTime() {
		return this.happenTime;
	}

	/**
	 * 设置城市编号
	 * @param cityId 城市编号
	 */
	public void setCityId(Integer cityId) {
		this.cityId = cityId;
	}

	public int getGoodsAmount() {
        return goodsAmount;
    }

    public void setGoodsAmount(int goodsAmount) {
        this.goodsAmount = goodsAmount;
    }

    /**
	 * 获取城市编号
	 * @return 城市编号
	 */
	public Integer getCityId() {
		return this.cityId;
	}

	/**
	 * 设置城市名称
	 * @param cityName 城市名称
	 */
	public void setCityName(String cityName) {
		this.cityName = cityName;
	}

	/**
	 * 获取城市名称
	 * @return 城市名称
	 */
	public String getCityName() {
		return this.cityName;
	}

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("Id",getId())
			.append("UserId",getUserId())
			.append("UserName",getUserName())
			.append("UserPhone",getUserPhone())
			.append("RuleId",getRuleId())
			.append("RuleName",getRuleName())
			.append("CommentId",getCommentId())
			.append("ReplyId",getReplyId())
			.append("GoodsId",getGoodsId())
			.append("GoodsName",getGoodsName())
			.append("OrderId",getOrderId())
			.append("Amount",getAmount())
			.append("RemainingAmount",getRemainingAmount())
			.append("HappenTime",getHappenTime())
			.append("CityId",getCityId())
			.append("CityName",getCityName())
			.toString();
	}

	/**
	 * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
	 * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof CmCreditRecordEntity == false) return false;
		if(this == obj) return true;
		CmCreditRecordEntity other = (CmCreditRecordEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

