package com.house365.beans.entity;

import com.google.common.base.Strings;
import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

/**
 * CmCreditGoods数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public class CmCreditGoodsEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 商品名称
     */
    @Length(max = 50, message = "长度需要大于0且小于50")
    private String goodsName;

    /**
     * 商品编码
     */
    @Length(max = 200, message = "长度需要大于0且小于200")
    private String goodsId;

    /**
     * 商品类型 0:实物 1:虚拟 2:第三方
     */
    @Length(max = 10, message = "长度需要大于0且小于10")
    private String goodsType;

    /**
     * 首页图片
     */
    @Length(max = 300, message = "长度需要大于0且小于300")
    private String indexPicture;

    /**
     * 详情大图
     */
    @Length(max = 300, message = "长度需要大于0且小于300")
    private String detailPicture;
    /**
     * 列表图片
     */
    private String listPicture;
    /**
     * 小列表图片
     */
    private String smallListPicture;

    /**
     * 兑换积分
     */
    private Integer creditsNeeded;

    /**
     * 市场价
     */
    private Float price;

    /**
     * 库存
     */
    private Integer stock;

    /**
     * 排序
     */
    private Integer orderNumber;

    /**
     * 是否已经提醒过
     */
    private Integer isReminded;

    /**
     * 商品描述
     */
    @Length(max = 1000, message = "长度需要大于0且小于1000")
    private String description;

    /**
     * 使用范围
     */
    @Length(max = 500, message = "长度需要大于0且小于500")
    private String usableRange;

    /**
     * 兑换流程
     */
    @Length(max = 500, message = "长度需要大于0且小于500")
    private String exchangeProcess;

    /**
     * 兑换次数
     */
    private Integer exchangedCount;

    /**
     * 注意事项
     */
    @Length(max = 500, message = "长度需要大于0且小于500")
    private String announcement;

    /**
     * 虚拟商品有效期开始
     */
    private java.util.Date startTime;

    /**
     * 虚拟商品有效期结束
     */
    private java.util.Date endTime;

    /**
     * 第三方商品自动下架时间
     */
    private Date autoSoldoutDate;

    /**
     * 商品状态 0:上架
     */
    private Integer status;

    /**
     * 城市id
     */
    private Integer cityId;

    /**
     * 城市id
     */
    private String cityKey;

    /**
     * 城市名称
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String cityName;

    /**
     * 更新时间
     */
    private java.util.Date updateTime;

    /**
     * 新建时间
     */
    private java.util.Date createTime;

    /**
     * 是否删除
     */
    private Integer isDeleted;

    /**
     * 批次Id
     */
    private String latestBatch;

    /**
     * 批次name
     */
    private String latestBatchName;

    /**
     * 广告链接
     */
    private String adLink;

    /**
     * 是否为秒杀商品 0:不是 1:是
     */
    private Integer isSeckill;

    /**
     * 商品是否抢光了 0:不是 1:是
     */
    private Integer isLooted;

    /**
     * 秒杀开始时间
     */
    private Date seckillStartTime;

    /**
     * 秒杀结束时间
     */
    private Date seckillEndTime;

    /**
     * 秒杀库存量(秒杀+兑换量)
     */
    private Integer seckillStock;

    /**
     * 当前秒杀活动订单量
     */
    private Integer seckillOrderCount;

    /**
     * sortValue
     */
    private Float sortValue;

    private HashMap<String, HashMap> promotions;

    //1 限购商品 0 不限购商品
    private Integer isBuyLimit;

    //第三方商品领取链接
    private String thirdLink;

    public Date getAutoSoldoutDate() {
        return autoSoldoutDate;
    }

    public void setAutoSoldoutDate(Date autoSoldoutDate) {
        this.autoSoldoutDate = autoSoldoutDate;
    }

    public Integer getIsBuyLimit() {
        return isBuyLimit;
    }

    public void setIsBuyLimit(Integer isBuyLimit) {
        this.isBuyLimit = isBuyLimit;
    }

    public HashMap<String, HashMap> getPromotions() {
        return promotions;
    }

    public void setPromotions(HashMap<String, HashMap> promotions) {
        this.promotions = promotions;
    }

    public Float getSortValue() {
        return sortValue;
    }

    public void setSortValue(Float sortValue) {
        this.sortValue = sortValue;
    }

    public Integer getIsLooted() {
        return isLooted;
    }

    public void setIsLooted(Integer isLooted) {
        this.isLooted = isLooted;
    }

    public Integer getIsSeckill() {
        return isSeckill;
    }

    public void setIsSeckill(Integer isSeckill) {
        this.isSeckill = isSeckill;
    }

    public Date getSeckillStartTime() {
        return seckillStartTime;
    }

    public void setSeckillStartTime(Date seckillStartTime) {
        this.seckillStartTime = seckillStartTime;
    }

    public Date getSeckillEndTime() {
        return seckillEndTime;
    }

    public void setSeckillEndTime(Date seckillEndTime) {
        this.seckillEndTime = seckillEndTime;
    }


    public Integer getSeckillOrderCount() {
        return seckillOrderCount;
    }

    public void setSeckillOrderCount(Integer seckillOrderCount) {
        this.seckillOrderCount = seckillOrderCount;
    }

    public Integer getSeckillStock() {
        return seckillStock;
    }

    public void setSeckillStock(Integer seckillStock) {
        this.seckillStock = seckillStock;
    }

    public String getAdLink() {
        return "http://m.house365.com/H5/Shopingmall/index.php?s=/Home/Goods/details/id/" + this.getId() + "/from/index.html";
    }

    public void setAdLink(String adLink) {
        this.adLink = adLink;
    }

    /**
     * 设置商品名称
     *
     * @param goodsName 商品名称
     */
    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public Integer getExchangedCount() {
        return exchangedCount;
    }

    public Integer getExchangedCountNotZero() {
        if (exchangedCount == null) {
            return 0;
        }
        return exchangedCount;
    }

    public void setExchangedCount(Integer exchangedCount) {
        this.exchangedCount = exchangedCount;
    }

    public String getSmallListPicture() {
        return smallListPicture;
    }

    public void setSmallListPicture(String smallListPicture) {
        this.smallListPicture = smallListPicture;
    }

    /**
     * 获取商品名称
     *
     * @return 商品名称
     */
    public String getGoodsName() {
        return this.goodsName;
    }

    /**
     * 设置商品编码
     *
     * @param goodsId 商品编码
     */
    public void setGoodsId(String goodsId) {
        this.goodsId = goodsId;
    }

    /**
     * 获取商品编码
     *
     * @return 商品编码
     */
    public String getGoodsId() {
        return this.goodsId;
    }

    /**
     * 设置商品类型 0:实物 1:虚拟
     *
     * @param goodsType 商品类型 0:实物 1:虚拟
     */
    public void setGoodsType(String goodsType) {
        this.goodsType = goodsType;
    }

    /**
     * 获取商品类型 0:实物 1:虚拟
     *
     * @return 商品类型 0:实物 1:虚拟 2:第三方
     */
    public String getGoodsType() {
        return this.goodsType;
    }

    /**
     * 设置首页图片
     *
     * @param indexPicture 首页图片
     */
    public void setIndexPicture(String indexPicture) {
        this.indexPicture = indexPicture;
    }

    /**
     * 获取首页图片
     *
     * @return 首页图片
     */
    public String getIndexPicture() {
        return this.indexPicture;
    }

    /**
     * 设置详情大图
     *
     * @param detailPicture 详情大图
     */
    public void setDetailPicture(String detailPicture) {
        this.detailPicture = detailPicture;
    }

    /**
     * 获取详情大图
     *
     * @return 详情大图
     */
    public String getDetailPicture() {
        return this.detailPicture;
    }

    /**
     * 设置兑换积分
     *
     * @param creditsNeeded 兑换积分
     */
    public void setCreditsNeeded(Integer creditsNeeded) {
        this.creditsNeeded = creditsNeeded;
    }

    /**
     * 获取兑换积分
     *
     * @return 兑换积分
     */
    public Integer getCreditsNeeded() {
        return this.creditsNeeded;
    }

    /**
     * 设置市场价
     *
     * @param price 市场价
     */
    public void setPrice(Float price) {
        this.price = price;
    }

    /**
     * 获取市场价
     *
     * @return 市场价
     */
    public Float getPrice() {
        return this.price;
    }

    /**
     * 设置库存
     *
     * @param stock 库存
     */
    public void setStock(Integer stock) {
        this.stock = stock;
    }

    /**
     * 获取库存
     *
     * @return 库存
     */
    public Integer getStock() {
        return this.stock;
    }

    /**
     * 设置排序
     *
     * @param orderNumber 排序
     */
    public void setOrderNumber(Integer orderNumber) {
        this.orderNumber = orderNumber;
    }

    /**
     * 获取排序
     *
     * @return 排序
     */
    public Integer getOrderNumber() {
        return this.orderNumber;
    }

    /**
     * 设置商品描述
     *
     * @param description 商品描述
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * 获取商品描述
     *
     * @return 商品描述
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * 设置使用范围
     *
     * @param usableRange 使用范围
     */
    public void setUsableRange(String usableRange) {
        this.usableRange = usableRange;
    }

    /**
     * 获取使用范围
     *
     * @return 使用范围
     */
    public String getUsableRange() {
        return this.usableRange;
    }

    /**
     * 设置兑换流程
     *
     * @param exchangeProcess 兑换流程
     */
    public void setExchangeProcess(String exchangeProcess) {
        this.exchangeProcess = exchangeProcess;
    }

    /**
     * 获取兑换流程
     *
     * @return 兑换流程
     */
    public String getExchangeProcess() {
        return this.exchangeProcess;
    }

    /**
     * 设置注意事项
     *
     * @param announcement 注意事项
     */
    public void setAnnouncement(String announcement) {
        this.announcement = announcement;
    }

    /**
     * 获取注意事项
     *
     * @return 注意事项
     */
    public String getAnnouncement() {
        return this.announcement;
    }

    /**
     * 设置虚拟商品有效期开始
     *
     * @param startTime 虚拟商品有效期开始
     */
    public void setStartTime(java.util.Date startTime) {
        this.startTime = startTime;
    }

    /**
     * 设置虚拟商品有效期开始字符串格式
     *
     * @param startTime 虚拟商品有效期开始
     */
    public void setStartTimeStr(String startTime) {
        if (!com.house365.web.util.StringUtils.isBlank(startTime)) {
            try {
                this.startTime = java.text.DateFormat.getDateTimeInstance().parse(startTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取虚拟商品有效期开始
     *
     * @return 虚拟商品有效期开始
     */
    public java.util.Date getStartTime() {
        return this.startTime;
    }

    /**
     * 设置虚拟商品有效期结束
     *
     * @param endTime 虚拟商品有效期结束
     */
    public void setEndTime(java.util.Date endTime) {
        this.endTime = endTime;
    }

    /**
     * 设置虚拟商品有效期结束字符串格式
     *
     * @param endTime 虚拟商品有效期结束
     */
    public void setEndTimeStr(String endTime) {
        if (!com.house365.web.util.StringUtils.isBlank(endTime)) {
            try {
                this.endTime = java.text.DateFormat.getDateTimeInstance().parse(endTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取虚拟商品有效期结束
     *
     * @return 虚拟商品有效期结束
     */
    public java.util.Date getEndTime() {
        return this.endTime;
    }

    /**
     * 设置商品状态 0:上架
     *
     * @param status 商品状态 0:上架
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取商品状态 0:上架
     *
     * @return 商品状态 0:上架
     */
    public Integer getStatus() {
        return this.status;
    }

    /**
     * 设置城市id
     *
     * @param cityId 城市id
     */
    public void setCityId(Integer cityId) {
        this.cityId = cityId;
    }

    /**
     * 获取城市id
     *
     * @return 城市id
     */
    public Integer getCityId() {
        return this.cityId;
    }

    public String getCityKey() {
        return cityKey;
    }

    public void setCityKey(String cityKey) {
        this.cityKey = cityKey;
    }

    /**
     * 设置城市名称
     *
     * @param cityName 城市名称
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public Integer getIsReminded() {
        return isReminded;
    }

    public void setIsReminded(Integer isReminded) {
        this.isReminded = isReminded;
    }

    /**
     * 获取城市名称
     *
     * @return 城市名称
     */
    public String getCityName() {
        return this.cityName;
    }

    /**
     * 设置更新时间
     *
     * @param updateTime 更新时间
     */
    public void setUpdateTime(java.util.Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 设置更新时间字符串格式
     *
     * @param updateTime 更新时间
     */
    public void setUpdateTimeStr(String updateTime) {
        if (!Strings.isNullOrEmpty(updateTime)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = null;
            try {
                date = sdf.parse(updateTime);
            } catch (java.text.ParseException ex) {
                sdf = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    date = sdf.parse(updateTime);
                } catch (ParseException e) {
                    e.printStackTrace();
                }
            } finally {
                this.updateTime = date;
            }
        }
    }

    /**
     * 获取更新时间
     *
     * @return 更新时间
     */
    public java.util.Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * 设置新建时间
     *
     * @param createTime 新建时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置新建时间字符串格式
     *
     * @param createTime 新建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取新建时间
     *
     * @return 新建时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置是否删除
     *
     * @param isDeleted 是否删除
     */
    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    /**
     * 获取是否删除
     *
     * @return 是否删除
     */
    public Integer getIsDeleted() {
        return this.isDeleted;
    }

    public String getLatestBatch() {
        return latestBatch;
    }

    public void setLatestBatch(String latestBatch) {
        this.latestBatch = latestBatch;
    }

    public String getLatestBatchName() {
        return latestBatchName;
    }

    public void setLatestBatchName(String latestBatchName) {
        this.latestBatchName = latestBatchName;
    }

    public String getThirdLink() {
        return thirdLink;
    }

    public void setThirdLink(String thirdLink) {
        this.thirdLink = thirdLink;
    }

    /**
     * @return the listPicture
     */
    public String getListPicture() {
        return listPicture;
    }

    /**
     * @param listPicture the listPicture to set
     */
    public void setListPicture(String listPicture) {
        this.listPicture = listPicture;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("GoodsName",
                                                                                                      getGoodsName()).append(
            "GoodsId", getGoodsId())

            .append("Stock", getStock())

            .toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if (obj instanceof CmCreditGoodsEntity == false)
            return false;
        if (this == obj)
            return true;
        CmCreditGoodsEntity other = (CmCreditGoodsEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }
}

