/**
 * Description: CmBrokerComment数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:06
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;

import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * CmBrokerComment数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public class CmBrokerCommentEntity extends DomainObject{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	//可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
	//columns START
	/**
	 * 经纪人编号
	 */
	
	private Integer brokerId;
	
	/**
	 * 来源
	 */
	private Integer source;
	
	/**
	 * 经纪人名称
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String brokerName;
	
	/**
     * 经纪人手机号
     */
    @Length(max=20, message="长度需要大于0且小于20")
    private String brokerPhone;
	
	public String getBrokerPhone() {
        return brokerPhone;
    }

    public void setBrokerPhone(String brokerPhone) {
        this.brokerPhone = brokerPhone;
    }

    /**
	 * 中介公司名称
	 */
	@Length(max=200, message="长度需要大于0且小于200")
	private String brokerCompanyName;
	
	/**
	 * 评论者编号
	 */
	
	private Integer criticCode;
	
	/**
	 * 评论者手机号
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String criticPhone;
	
	/**
	 * 评论者名称
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String criticName;
	
	/**
	 * 评分
	 */
	
	private Float criticScore;
	
	/**
	 * 评价内容
	 */
	@Length(max=500, message="长度需要大于0且小于500")
	private String criticContent;
	
	/**
	 * 可选标签
	 */
	@Length(max=100, message="长度需要大于0且小于100")
	private String labels;
	
	/**
	 * 是否匿名
	 */
	
	private Integer isAnonymous;
	
	/**
	 * 发布时间
	 */
	private java.util.Date publishTime;
	
	
	
	/**
     * 解禁时间
     */
    private java.util.Date activateTime;
	
	public java.util.Date getActivateTime() {
        return activateTime;
    }

    public void setActivateTime(java.util.Date activateTime) {
        this.activateTime = activateTime;
    }

    /**
	 * 城市ID
	 */
	
	private Integer cityId;
	
	/**
     * 用户头像
     */
    private String userPhoto;
    
    
    
	public String getUserPhoto() {
        return userPhoto;
    }

    public void setUserPhoto(String userPhoto) {
        this.userPhoto = userPhoto;
    }

    /**
	 * 城市名称
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String cityName;
	
	/**
     * 城市key
     */
    @Length(max=20, message="长度需要大于0且小于20")
    private String cityKey;
    
    public String getCityKey() {
        return cityKey;
    }

    public void setCityKey(String cityKey) {
        this.cityKey = cityKey;
    }
	
	/**
	 * 是否已读
	 */
	
	private Integer isReaded;
	
	/**
	 * 是否置顶
	 */
	
	private Integer isKicked;
	
	/**
	 * 是否删除
	 */
	
	private Integer isDeleted;
	
	public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    /**
     * 是否被举报
     */
    
    private Integer isReported;
	
	public Integer getIsReported() {
        return isReported;
    }

    public void setIsReported(Integer isReported) {
        this.isReported = isReported;
    }

    /**
	 * 设置经纪人编号
	 * @param brokerId 经纪人编号
	 */
	public void setBrokerId(Integer brokerId) {
		this.brokerId = brokerId;
	}

	/**
	 * 获取经纪人编号
	 * @return 经纪人编号
	 */
	public Integer getBrokerId() {
		return this.brokerId;
	}

	/**
	 * 设置经纪人名称
	 * @param brokerName 经纪人名称
	 */
	public void setBrokerName(String brokerName) {
		this.brokerName = brokerName;
	}

	/**
	 * 获取经纪人名称
	 * @return 经纪人名称
	 */
	public String getBrokerName() {
		return this.brokerName;
	}

	/**
	 * 设置中介公司名称
	 * @param brokerCompanyName 中介公司名称
	 */
	public void setBrokerCompanyName(String brokerCompanyName) {
		this.brokerCompanyName = brokerCompanyName;
	}

	/**
	 * 获取中介公司名称
	 * @return 中介公司名称
	 */
	public String getBrokerCompanyName() {
		return this.brokerCompanyName;
	}

	/**
	 * 设置评论者编号
	 * @param criticCode 评论者编号
	 */
	public void setCriticCode(Integer criticCode) {
		this.criticCode = criticCode;
	}

	/**
	 * 获取评论者编号
	 * @return 评论者编号
	 */
	public Integer getCriticCode() {
		return this.criticCode;
	}

	/**
	 * 设置评论者手机号
	 * @param criticPhone 评论者手机号
	 */
	public void setCriticPhone(String criticPhone) {
		this.criticPhone = criticPhone;
	}

	/**
	 * 获取评论者手机号
	 * @return 评论者手机号
	 */
	public String getCriticPhone() {
		return this.criticPhone;
	}

	/**
	 * 设置评论者名称
	 * @param criticName 评论者名称
	 */
	public void setCriticName(String criticName) {
		this.criticName = criticName;
	}

	/**
	 * 获取评论者名称
	 * @return 评论者名称
	 */
	public String getCriticName() {
		return this.criticName;
	}

	/**
	 * 设置评分
	 * @param criticScore 评分
	 */
	public void setCriticScore(Float criticScore) {
		this.criticScore = criticScore;
	}

	/**
	 * 获取评分
	 * @return 评分
	 */
	public Float getCriticScore() {
		return this.criticScore;
	}

	/**
	 * 设置评价内容
	 * @param criticContent 评价内容
	 */
	public void setCriticContent(String criticContent) {
		this.criticContent = criticContent;
	}

	/**
	 * 获取评价内容
	 * @return 评价内容
	 */
	public String getCriticContent() {
		return this.criticContent;
	}

	/**
	 * 设置可选标签
	 * @param labels 可选标签
	 */
	public void setLabels(String labels) {
		this.labels = labels;
	}

	/**
	 * 获取可选标签
	 * @return 可选标签
	 */
	public String getLabels() {
		return this.labels;
	}

	/**
	 * 设置是否匿名
	 * @param isAnonymous 是否匿名
	 */
	public void setIsAnonymous(Integer isAnonymous) {
		this.isAnonymous = isAnonymous;
	}

	/**
	 * 获取是否匿名
	 * @return 是否匿名
	 */
	public Integer getIsAnonymous() {
		return this.isAnonymous;
	}

	/**
	 * 设置发布时间
	 * @param publishTime 发布时间
	 */
	public void setPublishTime(java.util.Date publishTime) {
		this.publishTime = publishTime;
	}

	/**
	 * 设置发布时间字符串格式
	 * @param publishTime 发布时间
	 */
	public void setPublishTimeStr(String publishTime) {
		if (!com.house365.web.util.StringUtils.isBlank(publishTime)) {
			try {
				this.publishTime = java.text.DateFormat.getDateTimeInstance().parse(publishTime);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取发布时间
	 * @return 发布时间
	 */
	public java.util.Date getPublishTime() {
		return this.publishTime;
	}

	/**
	 * 设置城市ID
	 * @param cityId 城市ID
	 */
	public void setCityId(Integer cityId) {
		this.cityId = cityId;
	}

	/**
	 * 获取城市ID
	 * @return 城市ID
	 */
	public Integer getCityId() {
		return this.cityId;
	}

	/**
	 * 设置城市名称
	 * @param cityName 城市名称
	 */
	public void setCityName(String cityName) {
		this.cityName = cityName;
	}

	/**
	 * 获取城市名称
	 * @return 城市名称
	 */
	public String getCityName() {
		return this.cityName;
	}

	/**
	 * 设置是否已读
	 * @param isReaded 是否已读
	 */
	public void setIsReaded(Integer isReaded) {
		this.isReaded = isReaded;
	}

	/**
	 * 获取是否已读
	 * @return 是否已读
	 */
	public Integer getIsReaded() {
		return this.isReaded;
	}

	/**
	 * 设置是否置顶
	 * @param isKicked 是否置顶
	 */
	public void setIsKicked(Integer isKicked) {
		this.isKicked = isKicked;
	}

	/**
	 * 获取是否置顶
	 * @return 是否置顶
	 */
	public Integer getIsKicked() {
		return this.isKicked;
	}

	/**
	 * 设置是否删除
	 * @param isDeleted 是否删除
	 */
	public void setIsDeleted(Integer isDeleted) {
		this.isDeleted = isDeleted;
	}

	/**
	 * 获取是否删除
	 * @return 是否删除
	 */
	public Integer getIsDeleted() {
		return this.isDeleted;
	}

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("Id",getId())
			.append("BrokerId",getBrokerId())
			.append("BrokerName",getBrokerName())
			.append("BrokerCompanyName",getBrokerCompanyName())
			.append("CriticCode",getCriticCode())
			.append("CriticPhone",getCriticPhone())
			.append("CriticName",getCriticName())
			.append("CriticScore",getCriticScore())
			.append("CriticContent",getCriticContent())
			.append("Labels",getLabels())
			.append("IsAnonymous",getIsAnonymous())
			.append("PublishTime",getPublishTime())
			.append("CityId",getCityId())
			.append("CityName",getCityName())
			.append("IsReaded",getIsReaded())
			.append("IsKicked",getIsKicked())
			.append("IsDeleted",getIsDeleted())
			.toString();
	}

	/**
	 * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
	 * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof CmBrokerCommentEntity == false) return false;
		if(this == obj) return true;
		CmBrokerCommentEntity other = (CmBrokerCommentEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

