package com.house365.beans.entity;

import com.google.common.base.Splitter;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * Created by 365 on 2015/12/29.
 */
public class CheckScopeValidator implements ConstraintValidator<CheckScope, String> {
    String scope;

    @Override
    public void initialize(CheckScope checkScope) {
        this.scope = checkScope.value();
    }

    @Override
    public boolean isValid(String s, ConstraintValidatorContext constraintValidatorContext) {
        if (s == null) {
            return false;
        }

        Iterable<String> split = Splitter.on(",").split(s);
        for (String str : split) {
            if (str.equals(s)) {
                return true;
            }
        }

        return false;
    }
}
