package com.house365.web.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

/**
 * 登出过滤器<br>
 * add by jiangzhou
 */
public class LogoutFilter implements Filter {

    public LogoutFilter() {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException,
            ServletException {
        HttpServletRequest req = (HttpServletRequest)request ;
            // 删除Cookie中的SessionId
            Cookie[] cookies = req.getCookies();
            if(cookies != null && cookies.length > 0){
                for (Cookie cookie : cookies) {
                    cookie.setMaxAge(0);
                }
            }
        chain.doFilter(request, response);
    }

    /**
     * @param filterConfig 过滤器配置信息
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        return;
    }
}
