package com.house365.service.system.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.house365.beans.system.DomainObject;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.Interfaces.Service;

/**
 * 默认的Service实现
 * 
 */
public abstract class DefaultServiceImpl<T extends DomainObject> implements Service<T> {

    @Override
    public Integer save(T entity) {
        return getDao().save(entity);
    }
    
    /**
     * 批量插入
     * @author zhaodeshan
     * @version [版本号, 2015年2月4日]
     * @param entities
     * @since [产品/模块版本](可选)
     */
    @Override
    public void batchSave(Collection<T> entities)
    {
        getDao().save(entities);
    }

    @Override
    public void update(T entity) {
        getDao().update(entity);
    }
    
    /**
     * 批量更新
     * @author zhaodeshan
     * @version [版本号, 2015年2月4日]
     * @param entities
     * @since [产品/模块版本](可选)
     */
    @Override
    public void batchUpdate(Collection<T> entities)
    {
        getDao().update(entities);
    }

    @Override
    public void delete(Integer id) {
        getDao().delete(id);
    }

    @Override
    public void deleteByIds(Integer... ids) {
        getDao().deleteByIds(ids);
    }

    @Override
    public T getById(Integer id) {
        return getDao().getById(id);
    }

    @Override
    public List<T> queryByPage(QueryParams<?> queryParams) {
        return getDao().queryByPage(queryParams);
    }

    @Override
    public List<T> queryAll() {
        return getDao().queryAll();
    }

    @Override
    public List<T> queryAll(QueryParams<?> queryParams) {
        return getDao().queryAll(queryParams);
    }

    @Override
    public int getTotalCount(Object params) {
        return getDao().getTotalCount(params);
    }
    /**
     * 获取DAO实例<br>
     * 由子类通过自动注入或其他方式获取后，实现该方法返回具体实例
     * 
     * @return 获取DAO实例
     */
    protected abstract Dao<T> getDao();
}
