package com.house365.commons.system;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 自定义参数注释注解
 *
 * @author duhui
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface DescriptionParameter {
    
    // 参数类型
    public enum ParameterType {
        STRING, SHORT, INT, BOOL, LONG, OBJECT
    };

    // 参数名
    public String name();
    
    //  参数描述
    public String nameDesc();

    // 参数类型
    public ParameterType type() default ParameterType.STRING;
}
