package com.test;

import com.alibaba.dubbo.common.json.JSON;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Strings;
import com.house365.beans.entity.*;
import com.house365.beans.system.Page;
import com.house365.beans.system.QueryParams;
import com.house365.commons.system.HttpClientUtil;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.web.util.SpringContextUtil;
import com.house365.ws.Timer.GoodsRecycleTimer;
import com.house365.ws.cached.RedisUtilsInterface;
import com.house365.ws.dao.impl.CmHouseCommentDaoImpl;
import com.house365.ws.dao.interfaces.ICmCreditRecordDao;
import com.house365.ws.interfaces.rest.IAssessInterface;
import com.house365.ws.interfaces.rest.IHouseCommentListInterface;
import com.house365.ws.interfaces.server.ICmAssess;
import com.house365.ws.interfaces.server.ICmUser;
import com.house365.ws.service.interfaces.*;
import com.house365.ws.util.CityUtil;
import com.house365.ws.util.DateUtils;
import com.house365.ws.util.PhpInterfaceUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.io.IOException;
import java.io.Serializable;
import java.util.*;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Date: 16/2/1</p>
 *
 * @author XN
 * @version 1.0
 */
@ContextConfiguration(locations = {"classpath*:unittest/application/applicationContext*.xml"})
@RunWith(SpringJUnit4ClassRunner.class)
public class ServiceIT extends Assert {
    Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ICmProductStatService cmProductStatService;

    @Autowired
    private ICmCreditGoodsService cmCreditGoodsService;

    @Autowired
    private ICmCreditRecordService creditRecordService;

    @Autowired
    private ICmUserService userService;

    @Autowired
    private ICmCreditRecordDao cmCreditRecordDao;

    @Autowired
    private IAssessInterface cmAssessService;

    @Autowired
    private CmHouseCommentDaoImpl houseCommentDao;

    @Autowired
    private ICmHouseCommentService cmHouseCommentService;

    @Autowired
    private IHouseCommentListInterface houseCommentListInterface;

    @Autowired
    private ICmUser iCmUser;
    @Autowired
    private ICmPromotionProductService promotionProductService;

    @Autowired
    private GoodsRecycleTimer goodsRecycleTimer;

    @Autowired
    ICmLotteryRuleService<CmLotteryRuleEntity> iCmLotteryRuleService;

    @Autowired
    ICmAssess cmAssess;

    @Test
    public void testJob(){
        goodsRecycleTimer.soldoutJob();
    }

    @Test
    public void testGetInviteCount() {
        Map<String, Object> searchMap = new HashMap<>();
        searchMap.put("EQ_userPhone", "13770685961");
        searchMap.put("EQ_ruleId", "8");
        searchMap.put("GTE_happenTime", "2017-04-18 10:51:52");
        searchMap.put("LTE_andHappenTime", "2017-05-18 10:51:52");
        QueryParams queryParams = new QueryParams();
        queryParams.setSearchParams(searchMap);
        Integer count = creditRecordService.getUserInviteCount(queryParams);
        logger.info("======[{}]======", count);
    }

    @Test
    public void testLottery() {
        try {
            int rule1Count = 0;
            int rule2Count = 0;
            int rule3Count = 0;
            int rule4Count = 0;
            int rule5Count = 0;
            int rule6Count = 0;
            for (int i = 0; i < 10000; i++) {
                CmLotteryRuleEntity resultEntity = iCmLotteryRuleService.transGetSignedLotteryScore("167519", 1, "nj");
                if (6 == resultEntity.getId()) {
                    rule1Count++;
                } else if (4 == resultEntity.getId()) {
                    rule2Count++;
                } else if (5 == resultEntity.getId()) {
                    rule3Count++;
                } else if (1 == resultEntity.getId()) {
                    rule4Count++;
                } else if (2 == resultEntity.getId()) {
                    rule5Count++;
                } else if (3 == resultEntity.getId()) {
                    rule6Count++;
                }
                logger.info("=========lottery rule1:{}", rule1Count);
                logger.info("=========lottery rule2:{}", rule2Count);
                logger.info("=========lottery rule3:{}", rule3Count);
                logger.info("=========lottery rule4:{}", rule4Count);
                logger.info("=========lottery rule5:{}", rule5Count);
                logger.info("=========lottery rule6:{}", rule6Count);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Test
    public void changeUserCredit() {
        String url = "http://192.168.105.28:8188/house365-cm-web/rest/interface/";
        String productURL = "http://202.102.83.171:8012/house365-cm-web/rest/interface/";
        //调用时修改积分值
        String creit = "100";
        String rule = "9";
        //add 10
        String userids = "3148217,649677,1742299,634047,3141455,2958975,1976963,3148655,3023069,1548711,2567249,1943829,3114413,2312067,3147803,3147667,3009467,3049265,3099237,1460439,3133385,3071789,54859,2071087,2677377,2974547,2527363,3125495,2619053,2292165,3133215,3096389,19593,2292775,2704309,734881,2544837,2868633,2847039,1893517,1846959,2832949,715695,2196839,292817,2605077,3142819,3041083,154739,496291,1395217,1325929,1172717,1892083,1443725,2749441,3138359,3135285,3134093,3029679,6711,1926391,1643035,3147439,2574043,3077609,3052689,2948703,3104527,1269103,1611089,2716803,2027409,2156083,3124457,3104021,2265625,1317735,3003983,1326459,2301049,2218747,1820005,89513,3137847,3137951,2379441,1204023,2260133,1537561,1218027,2399237,1567149,1259926,2162777,1463581,2521637,1815539,3131963,2886693,3127101,3145773,2817003,3149661,2889527,3081491,3137519,3151541,1676009,3027607,3112411,113505,2816785,2474359,2983857,2952787,38661,3152207,3143339,3082715,3144873,3121665,2450747,3118651,3015071,2658079,748353,1640261,2193219,2314893,2983787,2963899,3141629,293057,290257,1852335,1186983,3147877";
        String add50Userids = "1185253,3071859,3071605,2731759,3148637,662215,2550085,2384545,3119419,610329,2595775,605419,2014447,54457,2114941,2238523,2856895,2540641,2890517,3142555,2813545,2490441,2663723,3112757,2523105,2287261,2287003,1854369,2363301,3094469,2990741,1229139,2072545,296365,2969065,1909899,2132063,3146603,1231667,2470337,2812433,179863,3016669,679941,1616551,399755,3152309,57771,1757635,153127,3116153,432487,3088389,3028621,2457877,3038157,2937,2994911,2900721,574423,1414389,1597825,2666407,3134683,3132949,2872177,3129269,3137991,1957121,314169,3151763,3139977,2817055,2041263,2994791,3043519,2153399,3131817,2394503,3066603,2394013,3139553,3099959,2087903,2979161,2436609,731115,3066741,683105,905,2607813,3118723,3086155,665939,2141143,1597613,349815,3140835,1619229,3138769,1926633,1266325,2473627,3057235,599501,1796221,3050105,2942467,2427857,2799405,2872479,1747789,3003571,3005079,3150927,2742075,3099887,2454233,3109481,2155969,2276221,1670799,2768189,3049939,3082499,2957599,3152181,333251,2335925,2268001,1867827,2241905,2261567,2185005,3136581,2881509,2784859,2949643,1851907,2578935,3131301,1506665,632025,35447,2867257,689461,2694357,3151963,1290323,3140659,3082829,1658559,1326863,2940999,620779,1213445,1874635";
        String add30Userids = "2020291,1270335,2859075,2946297,2466259,2933907,2647655,2266359,2690637,3151901,1871789,3151467,2346899,3130247,3137015,2415429,1951953,1991735,2917805,2059755,3149091,288847,3151869,343567,2249143,283625,2409037,3060071,1322239,2686779,1309043,2754677,1590603,3151361,2104419,2088321,2201467,2599179,694357,3142765,1990497,3122497,2750905,2098677,413317,169375,2032125,3084173,1567171,727163,620325,3149623,2710553,672597,1605707,2359433,1979825,2212185,3145537,2909447,3061189,3128033,635223,3027597,2376801,2749669,3058491,1217367,2413887,1312095,3052065,3088405,640581,20643,710867,1834145,661771,1930591,2018473,3151629,58787,733373,3126247,2754435,1266249,3137295,1554303,2872855,2065111,697351,1943591,124171,3129913,2833085,2659705,25773,1471021,2531045,3150113,325107,305813,626309,883441,2578305,2378623,1215181,718925,2333829,1893401,202361,2475805,2605271,2984501,1967389,1626567,1332415,3021411,3131515,806005,3129557,1347759,1427515,3033093,67191,2590119,1694203,2786315,690701,3133945,3150647,1824673,656399,2730053,1324991,3137317,2687717,2948939,1891075,3043021,637327,2184305,3137583,1890485,2654497,3142931,2000559,3115227,2466699,3060423,97425,2923935,121481,2275759,2228547,2537115,1347743,2673145,3000647,2070609,2963881,3147139,2248985,3124889,2522935,3127281,1874225,3141633,3119631,2520637,1616547,2356365,3124127,634429,705409,3134687,2313,3152221,2422431,549987,2134249,1357987,3136499,645017,859215,1766773,2528041,1928181,2695623,2215265,3067229,720823,1189829,3151317,367,1752079,1617293,3084591,1801179,3149221,2008889,3133021,2993849,614539,2837525,2295801,3115839,3127233,3136755,450927,1279567,3071159,2412401,3120243,3151557,2382411,2098729,1232025,95763,1523107,1179385,1263138,2516819,3144113,3136561,2319563,14915,1362649,3146561,91027,2325115,3124845,3132615,2282607,646343,1322079,655387,1662891,2049655,2784651,386625,573813,2402787,1870783,3069113,3150597,718517,2852777,291415,1930637,2013625,1524397,2488579,45217,328403,695373,2716717,1930549,649631,3054809,1079195,2839551,3130387,2470325,1972919,238089,3147113,956349,1921757,3115569,2277389,1438021,2730023,2176917,1883915,2346957,2519229,2970773,2205023,2218631,2501549,1334293,376363,3131575,1565457,3112079,2726807,3141559,731101,2687613,2466771,237919,3140217,2875821,3128421,2135411,3131205,3138815,1478867,2560151,2594247,2198235,2405733,1807241,2090491,2650591,660737,3144757,3127303,754411,3050235,1339247,2001099,3115843,3126195,3071075,41063,1863385,1460313,654273,293089,3113033,1845785,2750205,3144739,2965591,1824761,2875697,1902933,2005547,1665837,99575,3079293,721549,3147283,292723,433667,2701985,86857,1578635,607057,2524409,3102753,636491,2342503,2336911,2069725,3118525,3139481,2808597,1518573,1327917,3131559,46363,3076981,2734115,3135275,2665153,3147203,2022359,3141547,2979519,2902737,2865459,2560253,1311011,2982701,135273,2889193,2211595,2420543,2242997,2989391,3151277,2618117,1666909,3151781,1271683,3119221,2447157,584303,2530341,2016153,3151835,1779107,3050311,3005125,1207381,2621719,2985769,2038313,2982561,2680023,51643,3056333,3124107,1562641,1659661,2682733,1973905,3151515,2943637,1359163,3126971,2295511,1686207,2189517,2989699,3066511,1229283,3151243,2268037,1468469,1702513,3147605,3148577,2873295,3127767,2056765,2753641,1894967,2729921,3151923,674949,3128781,2620587,1860615,722957,2816287,2480629,2141837,3149743,2541939,2396575,3003921,3098441,2488741,2818385,2193655,2045711,3123991,3056359,3124853,1831327,1619751,1790569,1987699,1671551,3147347,2707651,2097923,3111587,3124585,3093921,3078747,2824597,3100577,2906423,404759,3142999,3142825,2466219,3084703,91169,2796059,3136963,2900617,3150109,1390001,2042317,3129989,3151647,3029665,597691,673833,1914626,2467953,3082647,2785779,2550643,2911007,2047269,3101473,2775647,1330053,3077895,2510269,2581791,3150537,3133519,3151699,3127147,2930615,2609515,3077153,3152059,2694013,2694649,3135423,2976085,3147337,2952195,1912288,3128925,2446759,2228889,3112501,527879,2425221,644661,2195455,731861,2203283,2994245,2638357,2566183,1667913,2173463,3151853,3071175,2624123,1658679,2174925,1520369,3140601,1705921,62085,1948379,2352487,2422819,2431371,9913,2627807,1706045,3015589,2990135,2347559,2333957,593197,3085393,3152229,1402993,2272589,2018505,3139573,2012495,3020253,2370835,166529,2937071,3070877,2205449,2520819,3013825,3151441,3124633,3028679,687049,1593071,2005051,2846835,3119457,2361843,1298101,2379873,652539,519751,3150899,3130195,1395365,3149077,2874669,2287957,237897,1940345,2279517,3104679,2261627,2342981,2730815,3151887,3146377,2410273,2810975,2721893,3151777,2429917,2623609,3151313,2950225,2409095,2694003,2976377,2605661,3070955,3150857,3151711,2956531,3076109,3097809,2380993,2994405,3063637,2878817,3150625,2457437,3134589,3145651,2703767,2699893,3124013,3062407,1955739,3142471,3141971,1973167,1995563,1527133,3134235,3084359,3083001,2590703,2781409,2812457,2429385,1867785,3142743,2024073,3133231,3151055,3146299,3132649,2800547,2914349,2520067,3034571,2074753,2977173,3139993,277951,2081935,2263665,3149857,3151967,2686011,1817885,2788151,2601071,2657707,3134865,1549087,2733515,3124573,3089949,619455,2571223,3056061,2541889,3096697,3121359,2519611,2771477,2609567,2368455,2937587,2732685,1315577,2996781,530527,3120331,1176483,2481913,1316695,1841485,2926687,562221,1867683,2980945,548713,1766493,1537929,2568909,3141453,1865871,2658277,1326443,3015121,2914017,1660035,1208395,3151267,3121583,3100871,2899533,2423305,3150027,1249040,3030371,2939743,1862545,199989,657915,2799251,3136473,3148531,2943659,3038849,3131359,3150615,3136103,3047493,3118125,2298013,3105083,3151559,3046349,2958201,717257,3090743,2457921,3030145,3036907,3064385,2626523,1367159,3077855,1266533,2825821,2619497,3151133,3129251,2489353,2911143,2668503,464717,886793,2200573,1716641,1676487,1685807,3025585,3145633,2699121,1954771,108011,3135867,3146931,272749,1452921,2741421,1710997,3150169,90891,1571347,3120569,134853,2939143,1925421,2403463,3151661,2980181,13311,45723,2048901,655973,12509,2711271,3141851,3063255,1628777,3152303,2502629,3144897,1893823,3061083,605313,2520027,2951029,133543,2911947,2754791,2871277,1420025,2835655,3100995,3151843,2784033,3149663,2001595,3131687,1525283,3055529,3140727,2382577,2501657,2257395,3079103,140589,1863527,3017083,3122839,1349033,680501,1837773,3131691,352083,289679,2525245,272499,2184657,2816401,2538339,511197,2531053,3071429,2754059,571,2468017,2964911,1140275,2039235,2079623,2043155,1894403,3090525,1182749,1746881,589023,2582261,3139807,3108807,3080431,1723205,393551,3133421,3117353,1229871,3086927,27659,3102439,2884755,3151971,3125667,3089509,3137631,3149733,3144437,3139223";
        int i = 0;
        for (String userid : userids.split(",")) {
            try {
                List<NameValuePair> pairs = new ArrayList<>();
                pairs.add(new BasicNameValuePair("serviceCode", "Cm"));
                pairs.add(new BasicNameValuePair("serviceName", "changeCredits"));
                pairs.add(new BasicNameValuePair("useridType", "1"));
                pairs.add(new BasicNameValuePair("userCityKey", "nj"));
                pairs.add(new BasicNameValuePair("rule", rule));
                pairs.add(new BasicNameValuePair("userId", userid));
                pairs.add(new BasicNameValuePair("amount", creit));
                HttpClientUtil.doGet(productURL, pairs, "");
                Thread.sleep(50);
                i++;
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.info("-----total[{}]----", i);
    }

    @Test
    public void testGetUserByUserid() {
        //本地库是否存在
        CmUserEntity cmUser = userService.getUserByUserIdCityKeyUserType("55269", "nj", 1);
        logger.info(cmUser.getUserId());
    }

    @Test
    public void testGetByUserId() {
        Map map = userService.getUserCreditTask("55269");
        logger.info(map.toString());
    }

    @Test
    public void testUpdateStatus() {
        promotionProductService.updateStatus(Lists.newArrayList(1, 422, 3), 1);
    }

    @Test
    public void testInitialData() {
        cmProductStatService.initialData();
    }

    @Test
    public void testSaveOrUpdate() {
        QueryParams<CmCreditGoodsEntity> goodQueryEntity = new QueryParams<>();
        int stock = 0;
        int checkStock = 0;
        String today = DateUtils.dateToString(new Date(), DateUtils.DATE);

        Integer productId = null;
        Map<String, Object> goodMap = new HashMap<>();
        goodMap.put("EQ_status", 0);
        goodQueryEntity.setSearchParams(goodMap);
        List<CmCreditGoodsEntity> goodsEntityList = cmCreditGoodsService.queryByPage(goodQueryEntity);
        if (!goodsEntityList.isEmpty()) {
            CmCreditGoodsEntity good = goodsEntityList.get(0);
            productId = good.getId();
            stock = good.getStock() + 11;
            good.setStock(stock);
            good.setDescription(today);
            cmProductStatService.saveOrUpdate(good);
        }

        if (productId != null) {
            QueryParams<CmProductStatEntity> productStatEntity = new QueryParams<>();
            Map<String, Object> statMap = new HashMap<>();
            statMap.put("EQ_productId", productId);
            statMap.put("EQ_statDate", today);
            productStatEntity.setSearchParams(statMap);
            List<CmProductStatEntity> productStatEntities = cmProductStatService.queryByPage(productStatEntity);

            if (!productStatEntities.isEmpty()) {
                CmProductStatEntity cmProductStatEntity = productStatEntities.get(0);
                checkStock = cmProductStatEntity.getEndStock();
            }
        }

        Assert.assertEquals(stock, checkStock);
    }

    @Test
    public void testRefreshStat() {
        cmProductStatService.refreshTask();
    }

    @Test
    public void testCache() {
        RedisUtilsInterface redisUtils = (RedisUtilsInterface) SpringContextUtil.getBean("redisUtils");

        String cache = redisUtils.getValByKey("");

        logger.info("cache is {}", cache);
    }

    @Test
    public void testGetCity() {
        List<KlfCityEntity> cityList = CityUtil.getCityList();
        logger.info("cityList size is {}", cityList.size());
    }

    @Test
    public void testGetByCity() {
        List<CmProductStatEntity> productStatEntities = cmProductStatService.statByCity();
        List<Map<String, String>> list = new ArrayList<>();

        for (CmProductStatEntity product : productStatEntities) {
            Map<String, String> map = new HashMap<>();
            map.put("name", product.getCityName());
            map.put("id", String.valueOf(product.getId()));
            list.add(map);
        }

        try {
            String json = JSON.json(list);
            System.out.println(json);
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    @Test
    public void testStatByDate() {
        List<CmProductStatEntity> productStatEntities = cmProductStatService.statByDate("六安");

        System.out.println(productStatEntities);
    }

    @Test
    public void testGetCreditListNew() {
        QueryParams<CmCreditRecordEntity> queryParams = new QueryParams<>();
        Map<String, Object> statMap = new HashMap<>();
        statMap.put("EQ_cityId", "nj");
        queryParams.setSearchParams(statMap);
        List<CmCreditRecordEntity> entities = creditRecordService.queryByPage(queryParams);
        logger.info("results is [{}]", entities.size());
    }

    @Test
    public void updateUserCity() {
        QueryParams<CmUserEntity> queryParams = new QueryParams<>();

        for (int i = 1; i < 1000; i++) {
            Page page = new Page(5000);
            page.setCurrentPage(i);
            queryParams.setPaging(page);
            List<CmUserEntity> cmUsers = userService.queryByPage(queryParams);
            if (cmUsers.isEmpty()) {
                break;
            } else {
                for (CmUserEntity user : cmUsers) {
                    if (Strings.isNullOrEmpty(user.getCityId())) {
                        CmUserEntity cmUser = PhpInterfaceUtils.getUserByRemoteInterface(user.getUserId());
                        if (!Strings.isNullOrEmpty(cmUser.getCityId())) {
                            user.setCityId(cmUser.getCityId());
                            userService.update(user);
                        }
                    }
                }
            }

        }

    }

    @Test
    public void testCheckByRule() {
        //        logger.info("result : {}", cmCreditRecordDao.checkByRule(1, 17064));
    }

    @Test
    public void testGetBlockByKeyword() {
        Map<String, Object> paramMap = new HashMap<>();
        String[] citys = {"nj"};
        String[] keywords = {"万科"};
        paramMap.put("city", citys);
        paramMap.put("keyword", keywords);
        try {
            Object obj = cmAssessService.getBlockByKeyword(paramMap);
            logger.info("get block by keyword{}", obj);
        } catch (ServiceRunException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testGetHouseCommentCache() {
        Parameter parameter = new Parameter();
        Map<String, Object> paramMap = new HashMap<>();
        String[] userId = {"1827137"};
        String[] currentPage = {"1"};
        String[] pageSize = {"3"};
        String[] channel = {"1"};
        String[] cityKey = {"nj"};
        String[] hasPicture = {"0"};
        String[] isExcellent = {"0"};
        String[] houseId = {"1402"};
        String[] userIdType = {"1"};
        String[] userCityKey = {"nj"};
        paramMap.put("userId", userId);
        paramMap.put("currentPage", currentPage);
        paramMap.put("pageSize", pageSize);
        paramMap.put("channel", channel);
        paramMap.put("cityKey", cityKey);
        paramMap.put("hasPicture", hasPicture);
        paramMap.put("isExcellent", isExcellent);
        paramMap.put("houseId", houseId);
        paramMap.put("userIdType", userIdType);
        paramMap.put("userCityKey", userCityKey);
        try {
            long beg = System.currentTimeMillis();
            parameter.setArgs(paramMap);
            Object obj = houseCommentListInterface.exectue(parameter);
            logger.info("houseCommentListInterface use :{}", System.currentTimeMillis() - beg);
        } catch (ServiceRunException e) {
            e.printStackTrace();
        }

    }

    @Test
    public void testRedis() {
        RedisUtilsInterface redisUtils = (RedisUtilsInterface) SpringContextUtil.getBean("redisUtils");
        boolean flag = redisUtils.isSetMember("1402_commentKeysKey",
                                              "comment_houseId_1402_currentPage_1_currentPage_1_pageSize_3_channel_1_cityKey_nj_hasPicture_0_isExcellent_0_userId_1827137_userIdType_null_userCityKey_nj");
        logger.info("flag :{}", flag);

        Set<Serializable> keys = redisUtils.getSetMember("1402_commentKeysKey");
        for (Serializable k : keys) {
            redisUtils.setRemove("1402_commentKeysKey", String.valueOf(k));
            logger.info("key :{}", k);
        }
    }

    @Test
    public void testGetRangeBlock() {
        Map<String, Object> paramMap = new HashMap<>();
        String[] citys = {"nj"};
        String[] x = {"118.792928"};
        String[] y = {"31.974484"};
        String[] range = {"100000"};
        String[] is_t_map = {"1"};
        paramMap.put("city", citys);
        paramMap.put("x", x);
        paramMap.put("y", y);
        paramMap.put("range", range);
        paramMap.put("is_t_map", is_t_map);
        try {
            Object obj = cmAssessService.getBlockByDistance(paramMap);
            logger.info("get block by distance{}", obj);
        } catch (ServiceRunException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testDistrictForMap() {
        Map<String, Object> paramMap = new HashMap<>();
        String[] citys = {"nj"};
        paramMap.put("city", citys);
        try {
            Object obj = cmAssessService.getDistrictForMap(paramMap);
            logger.info("get block by distance{}", obj);
        } catch (ServiceRunException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testGetCount() {
        boolean flag = cmHouseCommentService.checkCountNum(1740, 71);
        logger.info("flag is :{}", flag);
    }

    @Test
    public void testRemindUser() {
        iCmUser.signRemind();
    }

    @Test
    public void testRemoveRecord() {
        cmAssess.cleanRecordsJob();
    }

}
