package com.house365.ws.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.google.common.base.Strings;
import com.house365.beans.entity.CmBrokerEntity;
import com.house365.beans.entity.CmHouseEntity;
import com.house365.beans.entity.CmUserEntity;
import com.house365.beans.entity.KlfCityEntity;
import com.house365.commons.system.HttpClientUtil;
import com.house365.rest.context.CmConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhpInterfaceUtils {

    private static final Logger LOGGER = LoggerFactory.getLogger("InterfaceLog");

    /**
     * 通过用户ID获取用户信息
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @param userId
     * @return
     * @author yinchangming
     * @version [v1.0.0, 2015年9月1日]
     * @since [产品/模块版本](可选)
     */
    public static CmUserEntity getUserByRemoteInterface(String userId) {
        final String urlString = "http://api.house365.com/passport/passport_getuser_byuid.php?passport_uid=" + userId;

        // 接口地址 获取JSON字符串
        String jsonStr;
        try {
            jsonStr = HttpClientUtil.getJsonData(urlString);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return null;
        }

        Map<String, Object> mapData = HttpClientUtil.parseJSON2Map(jsonStr);

        LOGGER.info("call passport : URL{}, result {}", urlString, jsonStr);

        if ("1".equals(mapData.get("result").toString())) {
            LOGGER.info("call passport SUCCESS");
            if (mapData.get("data") != null) {
                Date now = new Date();
                Map<String, Object> user = (Map<String, Object>) mapData.get("data");
                String phone = (String) user.get("passport_phone");
                if (Strings.isNullOrEmpty(phone)) {
                    LOGGER.warn("userId:{}, phone is empty", userId);
                }
                String city = "";
                if (user.get("passport_city") != null && !"null".equalsIgnoreCase(
                    user.get("passport_city").toString())) {
                    city = String.valueOf(user.get("passport_city"));
                }
                CmUserEntity userEntity2 = new CmUserEntity();
                userEntity2.setPhoneNumber(phone);
                userEntity2.setUserName((String) user.get("username"));
                userEntity2.setUserPhoto((String) user.get("avatar"));
                userEntity2.setUserTruePhoto((String) user.get("passport_trueavatar"));
                userEntity2.setUserId((String) user.get("passport_uid"));
                userEntity2.setCityId(city);
                //userEntity2.setCity(cityName);
                userEntity2.setCreateTime(now);
                userEntity2.setUpdateTime(now);
                userEntity2.setStatus(0);
                userEntity2.setIsDeleted(0);
                userEntity2.setReportedCount(0);
                return userEntity2;
            }
        } else {
            LOGGER.warn("call passport FAIL");
        }
        return null;
    }

    /**
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @param houseId
     * @param cityKey
     * @return
     * @author yinchangming
     * @version [v1.0.0, 2015年9月1日]
     * @since [产品/模块版本](可选)
     */
    public static CmHouseEntity getHouseByRemoteInterface(String houseId, String cityKey, Integer channel) {
        //楼盘接口
        //http://newapi.house365.com/projects?city=nj&listid=10&channel=1
        //http://192.168.105.242/projects?channel=1&city=nj&listid=10
        String urlString = "http://newapi.house365.com/projects?";
        StringBuffer buffer = new StringBuffer(urlString);
        buffer.append("city=" + cityKey);
        buffer.append("&channel=" + channel);
        buffer.append("&listid=" + houseId);
        // 接口地址 获取JSON字符串
        String jsonStr = "";
        try {
            jsonStr = HttpClientUtil.getJsonData(buffer.toString());
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        Map<String, Object> mapData = HttpClientUtil.parseJSON2Map(jsonStr);
        if (mapData.get("data") != null) {
            if(mapData.get("data").getClass() == ArrayList.class){
                return null;
            }

            Map<String, Object> house = (Map<String, Object>) mapData.get("data");

            //entity.setHouseName((String)house.get("itemname"));

            CmHouseEntity houseEntity2 = new CmHouseEntity();
            houseEntity2.setChannel(channel);
            houseEntity2.setHouseId(Integer.valueOf(houseId));
            houseEntity2.setHouseName((String) house.get("itemname"));
            houseEntity2.setHousePhone((String) house.get("mobiletelephone"));
            houseEntity2.setTotolCommetAmount(0);
            houseEntity2.setCityKey(cityKey);
            houseEntity2.setCityName((String) house.get("city_name"));
            houseEntity2.setIsDeleted(0);

            houseEntity2.setEarliestComment(new Date());
            return houseEntity2;
        }
        return null;
    }

    /**
     * 获取经纪人接口
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @param brokerId
     * @param cityKey
     * @return
     * @author yinchangming
     * @version [v1.0.0, 2015年9月1日]
     * @since [产品/模块版本](可选)
     */
    public static CmBrokerEntity getBrokerByRemoteInterface(String brokerId, String cityKey) {
//        String urlString = "http://221.231.141.184/esf/web/get_broker_api.php";
        String urlString = "http://172.17.1.95/esf/web/get_broker_api.php";
        StringBuffer buffer = new StringBuffer(urlString);
        buffer.append("?conf_cityflag=" + cityKey);
        buffer.append("&id=" + brokerId);

        // 接口地址 获取JSON字符串
        String jsonStr;
        try {
            jsonStr = HttpClientUtil.getJsonData(buffer.toString());
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return null;
        }

        Map<String, Object> mapData = HttpClientUtil.parseJSON2Map(jsonStr);

        if ("1".equals(mapData.get("result"))) {
            if (mapData.get("data") != null) {
                Map<String, Object> broker = (Map<String, Object>) mapData.get("data");
                CmBrokerEntity brokerEntity = new CmBrokerEntity();
                //本地表不存在该Id的经纪人,从接口获取并插入本地表
                brokerEntity.setBrokerId(Integer.valueOf(brokerId));
                brokerEntity.setBrokerName((String) broker.get("truename"));
                brokerEntity.setBrokerPhone((String) broker.get("telno"));
                brokerEntity.setBrokerCompanyName((String) broker.get("agentshortname"));
                brokerEntity.setTotalCommetAmount(0);
                brokerEntity.setOneStarAmount(0);
                brokerEntity.setTwoStarAmount(0);
                brokerEntity.setThreeStarAmount(0);
                brokerEntity.setFourStarAmount(0);
                brokerEntity.setFiveStarAmount(0);
                //brokerEntity2.setCityId(Integer.valueOf(cityId));
                //brokerEntity2.setCityName(cityName);
                brokerEntity.setCityKey(cityKey);
                brokerEntity.setIsDeleted(0);
                return brokerEntity;
            }
        }
        return null;
    }

}
