/**
 * Description: CmUser业务接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:21
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.interfaces;

import com.house365.beans.entity.CmUserEntity;
import com.house365.service.system.Interfaces.Service;

import java.util.List;
import java.util.Map;

/**
 * CmUser业务接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public interface ICmUserService<T extends CmUserEntity> extends Service<T> {
    /**
     * 通过user_id字段获取用户信息
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @param userId
     * @return
     * @author yinchangming
     * @version [v1.0.0, 2015年8月24日]
     * @since [产品/模块版本](可选)
     */
    CmUserEntity getUserByUserIdCityKeyUserType(String userId, String cityKey, Integer useridType);

    /**
     * 注册新用户,不存在注册，存在则返回
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @param map
     * @return
     * @author yinchangming
     * @version [v1.0.0, 2015年8月24日]
     * @since [产品/模块版本](可选)
     */
    CmUserEntity registUserByUserId(Map<String, Object> map);

    void clearUserCache(String userId);

    /**
     * 功能描述: <br>
     * 获取注册积分
     *
     * @param cmUser
     * @param cityKey
     * @return
     * @author yinchangming
     * @version [v1.0.0, 2015年10月28日]
     * @since [产品/模块版本](可选)
     */
    Integer transGetRegisterScore(CmUserEntity cmUser, String cityKey) throws Exception;

    Integer transChangeUserCredit(CmUserEntity user, Integer rule, Integer credit) throws Exception;

    /**
     * 功能描述: <br>
     * 获取用户头像上传积分
     *
     * @param cmUser
     * @param cityKey
     * @return
     * @author yinchangming
     * @version [v1.0.0, 2015年10月28日]
     * @since [产品/模块版本](可选)
     */
    Integer transGetUploadUserPhotoScore(CmUserEntity cmUser, String cityKey) throws Exception;

    /**
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @return
     * @author yinchangming
     * @version [v1.0.0, 2015年11月6日]
     * @since [产品/模块版本](可选)
     */
    Integer countAllCreditsNotNull();

    /**
     * 查询所有积分余额
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @return
     * @author yinchangming
     * @version [v1.0.0, 2015年11月6日]
     * @since [产品/模块版本](可选)
     */
    Integer countAllRemainingCredits();

    Map getUserCreditTask(String userId);

    Integer countDeviceInvite(String deviceId);

    CmUserEntity getUserEntity(String userId);

    /**
     * 查询事业部榜单
     *
     * @param startTime
     * @param endTime   @return
     */
    List<CmUserEntity> selectRanksByDivision(String startTime, String endTime);

    /**
     * 查询个人榜单
     *
     * @param startTime
     * @param endTime   @return
     */
    List<CmUserEntity> selectRanksByInvite(String startTime, String endTime);

    /**
     * 查询个人推荐信息
     *
     * @param startTime
     * @param endTime   @return
     */
    CmUserEntity getRankByInvite(Integer userId, String startTime, String endTime);

}
