/**
 * Description: CmOrder业务接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:17
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.interfaces;

import java.util.List;
import java.util.Map;

import com.house365.beans.entity.CmOrderEntity;
import com.house365.beans.entity.CmUserEntity;
import com.house365.beans.system.QueryParams;
import com.house365.beans.vo.CmOrderVo;
import com.house365.rest.exception.ServiceRunException;
import com.house365.service.system.Interfaces.Service;

/**
 * CmOrder业务接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public interface ICmOrderService<T extends CmOrderEntity> extends Service<T> {

    /**
     * 查询订单累计的商品数量
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @author yinchangming
     * @version [v1.0.0, 2015年8月12日]
     * @param queryParams
     * @return
     * @since [产品/模块版本](可选)
     */
    List<CmOrderEntity> getCmOrderStatisticsList(QueryParams<CmOrderEntity> queryParams);
    
    Map<String,Object> transUpdateOrderStockIntegral(CmOrderVo orderVo) throws ServiceRunException;
    /**
     * 订单数在周期内是否过期
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @author yinchangming
     * @version [v1.0.0, 2015年10月29日]
     * @param userEntity
     * @return
     * @since [产品/模块版本](可选)
     */
    boolean isOrderOutOfLimits(CmUserEntity userEntity);

    //二次校验
    boolean isOrderOutOfLimitSecond(CmUserEntity userEntity);

    /**
     * 设定周期内的订单数量
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @author yinchangming
     * @version [v1.0.0, 2015年10月29日]
     * @param userEntity
     * @return
     * @since [产品/模块版本](可选)
     */
    Map<String,Integer> userOrderCountInCircle(CmUserEntity userEntity);

}
