/**
 * Description: CmHouseComment业务接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:15
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.interfaces;

import java.util.List;
import java.util.Map;

import com.house365.beans.entity.CmHouseCommentEntity;
import com.house365.beans.system.QueryParams;
import com.house365.beans.vo.CmHouseCommentVo;
import com.house365.service.system.Interfaces.Service;

/**
 * CmHouseComment业务接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public interface ICmHouseCommentService<T extends CmHouseCommentEntity> extends Service<T> {

    void removeCache(Integer houseId);

    //删除楼盘评价
    public Integer transDeleteHouseComment(String id,String isNoTalk);
    
    //楼盘评价
    public CmHouseCommentVo transHouseComment(Map<String, Object> map) throws Exception;

    //change user credit
    CmHouseCommentVo doChangeUserCredit(
        Integer commentId, Integer userId, Integer houseEntityId
    ) throws Exception;

    //楼盘评价列表
    public List<CmHouseCommentEntity> transHouseCommentList(QueryParams<CmHouseCommentEntity> queryParams);

    boolean checkCountNum(Integer userId, Integer houseId);
}
