/**
 * Description: CmHouseCommentReply业务接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-11 上午 09:31:50
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-11   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.interfaces;

import java.util.List;
import java.util.Map;

import com.house365.rest.parameter.House365RestObject;
import com.house365.service.system.Interfaces.Service;
import com.house365.beans.entity.CmHouseCommentReplyEntity;
import com.house365.beans.system.QueryParams;

/**
 * CmHouseCommentReply业务接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-11
 * @see
 * @since 1.0
 */
public interface ICmHouseCommentReplyService<T extends CmHouseCommentReplyEntity> extends Service<T> {
    
    //楼盘评价回复
    public House365RestObject<CmHouseCommentReplyEntity> transHouseCommentReply(Map<String, Object> map);
    
    //楼盘评价回复列表
    public List<CmHouseCommentReplyEntity> transHouseCommentReplyList(QueryParams<CmHouseCommentReplyEntity> queryParams);

    public List<CmHouseCommentReplyEntity> queryAllByLastDay(QueryParams<CmHouseCommentReplyEntity> queryParams);
}