/**
 * Description: CmCreditRecord业务接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-14 上午 09:30:51
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.interfaces;

import java.util.List;
import java.util.Map;

import com.house365.service.system.Interfaces.Service;
import com.house365.beans.entity.CmCreditRecordEntity;
import com.house365.beans.entity.CmUserEntity;
import com.house365.beans.system.QueryParams;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * CmCreditRecord业务接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-14
 * @see
 * @since 1.0
 */
public interface ICmCreditRecordService<T extends CmCreditRecordEntity> extends Service<T> {
    /**
     * 保存加精积分
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @author yinchangming
     * @version [v1.0.0, 2015年11月5日]
     * @param user
     * @param recordId
     * @return
     * @since [产品/模块版本](可选)
     */
    CmCreditRecordEntity saveAddExcellentRecord(CmUserEntity user, int recordId) throws Exception;
    
    /**
     * 获取条件内积分总和
     * 
     */
    Integer getTotalCreditsByCondition(QueryParams<CmCreditRecordEntity> queryParams);

    Integer getUserInviteCount(QueryParams<CmCreditRecordEntity> queryParams);

    /**
     *  获取条件内用户数（不重复）
     * 
     */
    Integer getDistinctUserCount(QueryParams<CmCreditRecordEntity> queryParams);
    

    List<CmCreditRecordEntity> statisticsByPage(QueryParams<?> queryParams);

    Integer statisticsByPageCount(QueryParams<CmCreditRecordEntity> queryParams);

    List<CmCreditRecordEntity> queryByPageNew(QueryParams<CmCreditRecordEntity> queryParams);

    CmCreditRecordEntity transAddCreditByQuestion(CmUserEntity user, String questionId);

    //业主社区发帖回帖
    @Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = {Exception.class})
    CmCreditRecordEntity transAddCreditByBbs(CmUserEntity user) throws Exception;

    //房博士提问扣积分
    @Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = {Exception.class})
    CmCreditRecordEntity transQestionMinusCredit(CmUserEntity user, Integer credit) throws Exception;

    //房博士送心意扣积分
    @Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = {Exception.class})
    CmCreditRecordEntity transSendGiftCredit(
        CmUserEntity user
    ) throws Exception;
}
