/**
 * Description: CmBrokerComment业务接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:06
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.interfaces;

import java.util.List;
import java.util.Map;

import com.house365.beans.entity.CmBrokerCommentEntity;
import com.house365.beans.entity.CmUserEntity;
import com.house365.beans.system.QueryParams;
import com.house365.service.system.Interfaces.Service;

/**
 * CmBrokerComment业务接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public interface ICmBrokerCommentService<T extends CmBrokerCommentEntity> extends Service<T> {
    //删除经纪人(逻辑删除)
    public Integer tranDeleteBroker(String id,String isNoTalk);
    
    //经纪人评价
    public String transBrokerComment(Map<String, Object> map, CmUserEntity entity) throws Exception;
    
    //经纪人评价列表
    public List<CmBrokerCommentEntity> transBrokerCommentList(QueryParams<CmBrokerCommentEntity> queryParams);
}