/**
 * Description: 商品促销关联业务实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-01 上午 10:52:46
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-01   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.common.base.Strings;
import com.house365.beans.entity.CmOrderEntity;
import com.house365.beans.entity.CmPromotionEntity;
import com.house365.beans.entity.CmUserEntity;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.interfaces.rest.GetGoodsListImpl;
import com.house365.ws.service.interfaces.ICmOrderService;
import com.house365.ws.service.interfaces.ICmPromotionService;
import com.house365.ws.service.interfaces.ICmUserService;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.house365.dao.system.interfaces.Dao;
import com.house365.beans.system.QueryParams;
import com.house365.service.system.impl.DefaultServiceImpl;

import com.house365.ws.dao.interfaces.ICmPromotionProductDao;
import com.house365.ws.service.interfaces.ICmPromotionProductService;
import com.house365.beans.entity.CmPromotionProductEntity;

/**
 * 商品促销关联业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-01
 * @see
 * @since 1.0
 */
@Service("cmPromotionProductService")
public class CmPromotionProductServiceImpl<T extends CmPromotionProductEntity> extends DefaultServiceImpl<T> implements ICmPromotionProductService<T> {

    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmPromotionProductServiceImpl.class);
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private ICmPromotionProductDao<T> cmPromotionProductDao;
    @Autowired
    ICmPromotionService promotionService;
    @Autowired
    ICmUserService cmUserService;
    @Autowired
    private ICmOrderService<CmOrderEntity> cmOrderService;

    @Override
    protected Dao<T> getDao() {
        return cmPromotionProductDao;
    }

    @Override
    public void updateStatus(List<String> productIds, int status) {
        cmPromotionProductDao.updateStatus(productIds, status);
    }

    /**
     * 获取商品对应的可用促销
     *
     * @param productId
     * @return
     */
    @Override
    public HashMap<String, HashMap> getProductHitPromotions(Integer productId) {
        //促销信息
        Map<String, Object> queryMap = new HashMap<>();
        queryMap.put("EQ_productId", productId);
        queryMap.put("EQ_status", 1);
        QueryParams ppq = new QueryParams();
        ppq.setSearchParams(queryMap);
        HashMap<String, HashMap> promotions = new HashMap<>();

        List<CmPromotionProductEntity> ppqList = (List<CmPromotionProductEntity>) queryAll(ppq);
        if (null != ppqList) {
            for (CmPromotionProductEntity pp : ppqList) {
                HashMap config = new HashMap();
                if (promotions.containsKey(String.valueOf(pp.getPromotionId()))) {
                    config = promotions.get(String.valueOf(pp.getPromotionId()));
                } else {
                    CmPromotionEntity pe = (CmPromotionEntity) promotionService.getById(pp.getPromotionId());
                    if (null != pe) {
                        config.put("name", pe.getDescription());
                    }
                }
                config.put(pp.getConfigKey(), pp.getConfigValue());
                promotions.put(String.valueOf(pp.getPromotionId()), config);
            }
        }

        return promotions;
    }

    /**
     * 检查用户是否满足新用户专享促销 返回检查结果
     *
     * @param promotions
     * @param userID
     * @return
     * @throws Exception
     */
    @Override
    public boolean checkUserIsHitNewUserPromotion(
        HashMap<String, HashMap> promotions, String userID
    ) throws Exception {
        boolean canUse = false;
        //新人专享促销
        if (!Strings.isNullOrEmpty(userID) && promotions.containsKey("1")) {

            CmUserEntity userEntity = cmUserService.getUserByUserIdCityKeyUserType(userID, "", 1);
            if (userEntity == null) {
                throw new ServiceRunException("该用户不存在!");
            }

            QueryParams orderQuery = new QueryParams();
            Map<String, Object> orderPara = new HashedMap();
            orderPara.put("EQ_userId", userEntity.getId());
            orderQuery.setSearchParams(orderPara);
            List<CmOrderEntity> orderEntities = cmOrderService.queryAll(orderQuery);

            HashMap config = promotions.get("1");

            String startDateTime = String.valueOf(config.get("startDate"));
            DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

            if ((!Strings.isNullOrEmpty(startDateTime) && userEntity.getCreateTime().before(
                dateFormat.parse(startDateTime))) || !orderEntities.isEmpty()) {
                config.put("canUse", "0");
                config.put("msg", "本商品为" + startDateTime + "之后新注册会员首次兑换专享");
            } else {
                canUse = true;
                config.put("canUse", "1");
                config.put("msg", "");
            }

        }
        return canUse;
    }

}
