/**
 * Description: CmHouse业务实现类
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:14
 * <p/>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import java.util.List;
import java.util.Map;

import com.google.common.base.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import com.house365.dao.system.interfaces.Dao;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.CmConstant;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.ICmHouseDao;
import com.house365.ws.service.interfaces.ICmHouseService;
import com.house365.beans.entity.CmHouseEntity;

/**
 * CmHouse业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Service("cmHouseService")
public class CmHouseServiceImpl<T extends CmHouseEntity> extends DefaultServiceImpl<T> implements ICmHouseService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private ICmHouseDao<T> cmHouseDao;

    @Override
    protected Dao<T> getDao() {
        return cmHouseDao;
    }

    @Override
    public CmHouseEntity transGetHouseById(Map<String, Object> map) {
        // 楼盘Id
        String houseId = null;
        String cityKey = null;
        Integer channel = 0;
        if (map.get(CmConstant.HOUSEID) != null) {
            houseId = ((String[]) map.get(CmConstant.HOUSEID))[0];
        }

        if (map.get(CmConstant.CITY_KEY) != null) {
            cityKey = ((String[]) map.get(CmConstant.CITY_KEY))[0];
        }

        if (map.get(CmConstant.CHANNEL) != null) {
            String[] channels = (String[]) map.get(CmConstant.CHANNEL);
            if (channels.length > 0 && !Strings.isNullOrEmpty(channels[0])) {
                channel = Integer.parseInt(channels[0]);
            }
        }

        CmHouseEntity entity = null;
        if (!Strings.isNullOrEmpty(houseId)) {
            entity = cmHouseDao.getHouseByHouseId(Integer.valueOf(houseId), cityKey, channel);
        }

        return entity;
    }

    @Override
    public void increaseComment(Integer id) {
        cmHouseDao.increaseComment(id);
    }
}
