/**
 * Description: CmExchangeCode业务实现类
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:13
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.house365.beans.entity.CmExchangeCodeEntity;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.ICmExchangeCodeDao;
import com.house365.ws.service.interfaces.ICmExchangeCodeService;

/**
 * CmExchangeCode业务实现类<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Service("cmExchangeCodeService")
public class CmExchangeCodeServiceImpl<T extends CmExchangeCodeEntity> extends DefaultServiceImpl<T> implements ICmExchangeCodeService<T> {
	/**
	 * 自动注入的数据访问对象
	 */
	@Autowired
	private ICmExchangeCodeDao<T> cmExchangeCodeDao;

    @Override
    protected Dao<T> getDao() {
        return cmExchangeCodeDao;
    }

	@Override
	public Integer deleteByBatchCode(Integer batchId) {
		return cmExchangeCodeDao.deleteByBatchCode(batchId);
	}

	@Override
	public List<CmExchangeCodeEntity> getNotRepeat(Map<String,Object> params) {
		return cmExchangeCodeDao.getNotRepeat(params);
	}

	@Override
	public CmExchangeCodeEntity getIsRepeat(Map<String, Object> params) {
		return cmExchangeCodeDao.getIsRepeat(params);
	}
}