/**
 * Description: CmBroker业务实现类
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 18:47:32
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.house365.beans.entity.CmBrokerEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.ICmBrokerDao;
import com.house365.ws.service.interfaces.ICmBrokerService;

/**
 * CmBroker业务实现类<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Service("cmBrokerService")
public class CmBrokerServiceImpl<T extends CmBrokerEntity> extends DefaultServiceImpl<T> implements ICmBrokerService<T> {
	/**
	 * 自动注入的数据访问对象
	 */
	@Autowired
	private ICmBrokerDao<T> cmBrokerDao;

    @Override
    protected Dao<T> getDao() {
        return cmBrokerDao;
    }

    @Override
    public CmBrokerEntity getBrokerByBrokerId(String brokerId, String cityKey) {
        QueryParams<T> queryParams = new QueryParams<T>();
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("EQ_brokerId", brokerId);
        map.put("EQ_cityKey", cityKey);
        queryParams.setSearchParams(map);
        List<T> list = this.getDao().queryAll(queryParams);
        if(list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }
    
    
}