/*
 * Copyright (C), 2002-2015, 江苏三六五网络股份有限公司
 * FileName: ExchangeUserLoginInterfaceImpl.java
 * Author:   Administrator
 * Date:     2015年5月5日 下午2:57:41
 * Description: //模块目的、功能描述      
 * History: //修改记录
 * <author>      <time>      <version>    <desc>
 * 修改人姓名             修改时间            版本号                  描述
 */
package com.house365.ws.interfaces.rest;

import com.house365.beans.entity.*;
import com.house365.beans.system.Page;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.CmConstant;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.IllegalServiceParameterException;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.dao.interfaces.ICmHouseDao;
import com.house365.ws.dao.interfaces.ICmPraiseDao;
import com.house365.ws.service.interfaces.ICmHouseCommentReplyService;
import com.house365.ws.service.interfaces.ICmHouseCommentService;
import com.house365.ws.service.interfaces.ICmUserService;
import com.house365.ws.system.ReturnAppResult;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 〈一句话功能简述〉<br>
 * 〈功能详细描述〉
 *
 * @author Administrator
 * @version [版本号, 2015年5月5日]
 * @see [相关类/方法]（可选）
 * @since [产品/模块版本] （可选）
 */
@Component("userOwnHouseCommentListInterface")
public class UserOwnHouseCommentListInterfaceImpl implements IUserOwnHouseCommentListInterface {

    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(UserOwnHouseCommentListInterfaceImpl.class);
    
    @Autowired
    private ICmHouseCommentService<CmHouseCommentEntity> houseCommentService;
    @Autowired
    private ICmHouseDao<CmHouseEntity> houseDao;
    @Autowired
    private ICmUserService<CmUserEntity> cmUserService;
    @Autowired
    private ICmPraiseDao<CmPraiseEntity> cmPraise;
    @Autowired
    private ICmHouseCommentReplyService<CmHouseCommentReplyEntity> houseCommentReplyService;
    
    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        House365RestResponse<CmHouseCommentEntity> response = new House365RestResponse<CmHouseCommentEntity>();
        // 业务校验统一入口
        try {
            checkInterfaceParameter(map);
        } catch (IllegalServiceParameterException e) {
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg(e.getMessage());
            return JSONObject.fromObject(response).toString();
        }
        // 业务层统一处理
        try {
            House365RestObject<CmHouseCommentEntity> data = doBusiness(map);
            response.setData(data);
            if (StringUtils.isEmpty(data.getTotal())) {
                response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
                response.setMsg("操作失败");
            } else {
                response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
                response.setMsg("操作成功");
            }

        } catch (ServiceRunException e) {
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg(e.getMessage());
        }

        return JSONObject.fromObject(response).toString();
    }

    /**
     * 
     * 业务层统校验自己所需参数是否存在
     *
     * @author yangyang
     * @version [v1.0.0, 2015年8月18日]
     * @param map 请求参数封装成Map对象
     * @return 统一返回参数
     * @since [产品/模块版本](可选)
     */
    protected void checkInterfaceParameter(Map<String, Object> map) throws IllegalServiceParameterException {

        // 方法所需参数
        for (String str : CmConstant.UserOwnHouseCommentList) {
            // 如果不存在跳出 同时抛出相应异常
            if (!map.containsKey(str)) {
                LOGGER.error("业务入口参数异常：" + str + "参数为空!");
                throw new IllegalServiceParameterException("业务入口参数异常：" + str + "参数为空!");
            }

        }
    }

    /**
     * 
     * 业务层统逻辑处理
     *
     * @author yangyang
     * @version [v1.0.0, 2015年7月1日]
     * @param
     * @return 统一返回参数
     * @throws ServiceRunException
     * @since [产品/模块版本](可选)
     */
    protected House365RestObject<CmHouseCommentEntity> doBusiness(Map<String, Object> map) throws ServiceRunException {
        // 返回Json对象
        House365RestObject<CmHouseCommentEntity> restObject = new House365RestObject<CmHouseCommentEntity>();
        try {
            
            // 当前页
            Integer currentPage = null;
            // 当前页
            Integer pageSize = null;
            //用户id
            String userId=null;
            //用户id类型
            Integer userIdType=null;
            //用户所在城市
            String userCityKey=null;
            
            if (!StringUtils.isEmpty(map.get(CmConstant.USER_ID))) {
                userId = ((String[]) map.get(CmConstant.USER_ID))[0];
            }
            if (!StringUtils.isEmpty(map.get(CmConstant.USERID_TYPE))) {
                userIdType = Integer.parseInt(((String[]) map.get(CmConstant.USERID_TYPE))[0]);
            }
            if (!StringUtils.isEmpty(map.get(CmConstant.USER_CITY_KEY))) {
                userCityKey = ((String[]) map.get(CmConstant.USER_CITY_KEY))[0];
            }
            
            if (!StringUtils.isEmpty(map.get(CmConstant.PAGE))) {
                currentPage = Integer.parseInt(((String[]) map.get(CmConstant.PAGE))[0]);
            }
            if (!StringUtils.isEmpty(map.get(CmConstant.PAGESIZE))) {
                pageSize =  Integer.parseInt(((String[]) map.get(CmConstant.PAGESIZE))[0]);
            }
              
            CmUserEntity cmUser = cmUserService.getUserByUserIdCityKeyUserType(userId, userCityKey, userIdType);
            if(cmUser==null){
                throw new ServiceRunException("用户不存在！");
            }
            //回复数量置零
            cmUser.setUnreadReply(0);
            cmUserService.update(cmUser);

            Map<String, Object> queryMap = new HashMap<String, Object>();
            queryMap.put("EQ_criticId", cmUser.getId());
            queryMap.put("EQ_isDeleted", "0");
            QueryParams<CmHouseCommentEntity> queryParams = new QueryParams<CmHouseCommentEntity>();
            queryParams.setSearchParams(queryMap);
            Page page = new Page();
            page.setCurrentPage(currentPage);
            page.setPageSize(pageSize);
            queryParams.setPaging(page);
            queryParams.setOrderColumn("comment_date");
            queryParams.setOrderMode("desc");
            List<CmHouseCommentEntity> cmHouseCommentsList = houseCommentService.queryByPage(queryParams);
            for (CmHouseCommentEntity repEntity : cmHouseCommentsList) {
                Map<String, Object> replyQueryMap = new HashMap<>();
                replyQueryMap.put("EQ_commentId", repEntity.getId());
                replyQueryMap.put("EQ_isReplyByManager", 1);
                replyQueryMap.put("EQ_isDeleted", 0);
                QueryParams<?> replyQuery = new QueryParams<>();
                replyQuery.setSearchParams(replyQueryMap);
                List<CmHouseCommentReplyEntity> managerReplylist = houseCommentReplyService.queryByPage(replyQuery);
                if (managerReplylist != null && managerReplylist.size() != 0) {
                    repEntity.setManagerReply(managerReplylist.get(0));
                }
            }
            if(currentPage>page.getPages()){
                restObject.setList(null);
            }else{
                restObject.setList(cmHouseCommentsList);
            }
        	restObject.setTotal(String.valueOf(queryParams.getPaging().getRecords()));
            return restObject;
        } catch (Exception ex) {
        	ex.printStackTrace();
            LOGGER.error("积分商城-楼盘评论列表数据异常！");
            throw new ServiceRunException(ex.getMessage());
        }
    }


    /**
     * 判断服务是否具有控制逻辑
     * 
     * @return 是否判断
     */
    public boolean isControlService() {

        return false;
    }

    /**
     * 判断服务是否需要记录日志
     * 
     * @return 是否判断
     */
    public boolean isLogService() {

        return false;
    }

    /**
     * 判断服务是否需要监控
     * 
     * @return 是否判断
     */
    public boolean isMonitorService() {

        return false;
    }

    /**
     * 事务回滚
     * 
     * @return 事务回滚预留结果，暂无用途
     */
    public Object rollback() {

        return null;
    }

    /**
     * 事务提交
     */
    public void commit() {

    }
}
