package com.house365.ws.interfaces.rest;

import com.house365.beans.entity.CmUserEntity;
import com.house365.rest.context.CmConstant;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.IllegalServiceParameterException;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.service.interfaces.ICmUserService;
import com.house365.ws.system.ReturnAppResult;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component("updateUserInfoInterface")
public class UpdateUserInfoInterfaceImpl implements IUpdateUserInfoInterface {

    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateUserInfoInterfaceImpl.class);

    @Autowired
    ICmUserService<CmUserEntity> cmUserService;

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {

        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        House365RestResponse<Map<String, Object>> response = new House365RestResponse<Map<String, Object>>();
        String userId = ((String[]) map.get(CmConstant.USERID))[0];
        // 业务校验统一入口
        try {
            checkInterfaceParameter(map);
        } catch (IllegalServiceParameterException e) {
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg(e.getMessage());
            return JSONObject.fromObject(response).toString();
        }
        // 业务层统一处理
        try {
            //1代表用户中心用户
            CmUserEntity cmUser = cmUserService.getUserByUserIdCityKeyUserType(userId, "", 1);
            response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
            response.setMsg("操作成功");
            if (cmUser == null) {
                return JSONObject.fromObject(response).toString();
            }
            doBusiness(map, cmUser);
        } catch (ServiceRunException e) {
            e.printStackTrace();
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg(e.getMessage());
        }
        response.setData(null);
        return JSONObject.fromObject(response).toString();
    }

    /**
     * 业务层统校验自己所需参数是否存在
     *
     * @param map 请求参数封装成Map对象
     * @return 统一返回参数
     * @author yinchangming
     * @version [v1.0.0, 2015年8月18日]
     * @since [产品/模块版本](可选)
     */
    protected void checkInterfaceParameter(Map<String, Object> map) throws IllegalServiceParameterException {

        // 方法所需参数
        for (String str : CmConstant.UPDATE_USER_INFO_PARAMS) {
            // 如果不存在跳出 同时抛出相应异常
            if (!map.containsKey(str)) {
                LOGGER.error("业务入口参数异常：" + str + "参数为空!");
                throw new IllegalServiceParameterException("业务入口参数异常：" + str + "参数为空!");
            }
        }
    }

    /**
     * 业务层统逻辑处理
     *
     * @param
     * @return 统一返回参数
     * @throws ServiceRunException
     * @author yangyang
     * @version [v1.0.0, 2015年7月1日]
     * @since [产品/模块版本](可选)
     */
    protected void doBusiness(Map<String, Object> map, CmUserEntity cmUser) throws ServiceRunException {
        try {
            // 返回Json对象
            if (map.get(CmConstant.USER_PHOTO) != null) {
                cmUser.setUserPhoto(((String[]) map.get(CmConstant.USER_PHOTO))[0]);
            }
            // 返回Json对象
            if (map.get(CmConstant.USER_PHONE) != null) {
                cmUser.setPhoneNumber(((String[]) map.get(CmConstant.USER_PHONE))[0]);
            }
            // 返回Json对象
            if (map.get(CmConstant.USER_NAME) != null) {
                cmUser.setUserName(((String[]) map.get(CmConstant.USER_NAME))[0]);
            }
            cmUserService.update(cmUser);
        } catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRunException("保存出错!");
        }
    }

    @Override
    public boolean isControlService() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean isLogService() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean isMonitorService() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public Object rollback() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void commit() {
        // TODO Auto-generated method stub

    }

}
