/*
 * Copyright (C), 2002-2015, 江苏三六五网络股份有限公司
 * FileName: ExchangeUserLoginInterfaceImpl.java
 * Author:   Administrator
 * Date:     2015年5月5日 下午2:57:41
 * Description: //模块目的、功能描述      
 * History: //修改记录
 * <author>      <time>      <version>    <desc>
 * 修改人姓名             修改时间            版本号                  描述
 */
package com.house365.ws.interfaces.rest;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.common.base.Strings;
import com.house365.ws.service.interfaces.ICmPromotionProductService;
import com.house365.ws.service.interfaces.ICmPromotionService;
import com.house365.ws.service.interfaces.ICmUserService;
import com.house365.ws.util.CmCommonUtils;
import net.sf.json.JSONObject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.house365.beans.entity.CmCreditGoodsEntity;
import com.house365.beans.entity.CmSeckillBookedEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.CmConstant;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.IllegalServiceParameterException;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.cached.RedisUtilsInterface;
import com.house365.ws.dao.interfaces.ICmCreditGoodsDao;
import com.house365.ws.dao.interfaces.ICmSeckillBookedDao;
import com.house365.ws.system.ReturnAppResult;

/**
 * 〈一句话功能简述〉<br>
 * 〈功能详细描述〉
 *
 * @author Administrator
 * @version [版本号, 2015年5月5日]
 * @see [相关类/方法]（可选）
 * @since [产品/模块版本] （可选）
 */
@Component("secKillSubmitInterface")
public class SecKillSubmitInterfaceImpl implements ISecKillSubmitInterface {

	/*
     * static int iiCount=0;
	 * 
	 * public static synchronized int increaseCount(){ return iiCount++; }
	 */

    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(SecKillSubmitInterfaceImpl.class);

    /**
     * 接口参数手机号码
     */
    private static final String USERPHONE = "userPhone";

    /**
     * 购买商品Id
     */
    private static final String GOODSID = "goodsId";

    /**
     * 购买商品Id
     */
    private static final String USERID = "userId";

    /**
     * 周期内最多订单数, 默认2次
     */
    @Value("#{system.orderLimitCount}")
    private Integer ORDER_LIMIT_COUNT = 0;

    /**
     * 定义常量
     */
    public static final String[] CreditGoodsDetails = {};

    @Autowired
    private ICmCreditGoodsDao<CmCreditGoodsEntity> cmCreditGoodsDao;

    @Autowired
    private ICmSeckillBookedDao<CmSeckillBookedEntity> secKillBoockedDao;

    @Autowired
    RedisUtilsInterface redisUtils;

    @Autowired
    ICmPromotionProductService promotionProductService;
    @Autowired
    ICmPromotionService promotionService;
    @Autowired
    ICmUserService cmUserService;

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        Map<String, Object> response = new HashMap<>();
        // 业务校验统一入口
        try {
            CmCommonUtils.checkInterfaceParameter(CreditGoodsDetails, map);
        } catch (IllegalServiceParameterException e) {
            response.put("result", ReturnAppResult.APP_FAIL.getResultCode());
            response.put("msg", e.getMessage());
            return JSONObject.fromObject(response).toString();
        }
        // 业务层统一处理
        try {
            Map<String, Object> data = doBusiness(map);
            Integer orderCode = Integer.parseInt(data.get("code").toString());
            if (orderCode > 0) {
                response.put("data", data);
                response.put("result", ReturnAppResult.APP_SUCCESS.getResultCode());
                response.put("msg", ReturnAppResult.APP_SUCCESS.getResultMessage());
            } else {
                response.put("result", ReturnAppResult.APP_FAIL.getResultCode());
                response.put("msg", data.get("msg").toString());
            }
        } catch (ServiceRunException e) {
            response.put("result", ReturnAppResult.APP_FAIL.getResultCode());
            response.put("msg", e.getMessage());
        }
        return JSONObject.fromObject(response).toString();
    }


    /**
     * 业务层统逻辑处理
     *
     * @param
     * @return 统一返回参数
     * @throws ServiceRunException
     * @author nizhengjia
     * @version [v1.0.0, 2015年8月18日]
     * @since [产品/模块版本](可选)
     */
    @SuppressWarnings("null")
    protected Map<String, Object> doBusiness(Map<String, Object> map) throws ServiceRunException {
        // 返回Json对象
        Map<String, Object> resultMap = new HashMap<>();

        /**
         * 入参：用户Id,用户手机,购买商品Id,购买商品数据,手机验证码, 抢单数量达到库存后，直接排除其他用户（用户id需要唯一，不给重复刷单）
         * redis list存放库存，成功从list中减一
         *
         */
        try {
            if (map.get(USERID) == null || map.get(GOODSID) == null) {
                throw new Exception("SecKillSubmit: userId or goodId is empty !!!");
            }

            String phone = map.get(USERPHONE) == null ? "" : ((String[]) map.get(USERPHONE))[0];
            Integer goodsId = Integer.parseInt(((String[]) map.get(GOODSID))[0]);
            String userId = ((String[]) map.get(USERID))[0];

            resultMap.put("time", new Date());
            String time = redisUtils.getValByKey("prduct:seckill:time:" + goodsId);
            if (!Strings.isNullOrEmpty(time) && !"null".equalsIgnoreCase(time)) {
                long now = new Date().getTime();
                long startTime = Long.parseLong(time);
                if (now < startTime) {
                    resultMap.put("code", "4");
                    resultMap.put("msg", "还没有开始哦~");
                    return resultMap;
                }
            }

            // 判断一个人是否已经抢过
            // String userGoods =
            // redisUtils.getValByKey(CmConstant.SECKILL_USER_GOODS+userId+":"+goodsId);
            // if(userGoods!=null)
            // 获取jedis链接
            // Jedis jedisClient = redisConnectionPool.getResource();
            //			Long currentCount = redisUtils.decreaseByKey(CmConstant.SECKILL_CURRENT_COUNT + goodsId);
            Integer goodCount = redisUtils.popIntegerFromRedisList(CmConstant.SECKILL_LEFT_STOCK_LIST + goodsId);

            if (goodCount == null || goodCount != 1) {
                // redisUtils.increaseByKey(CmConstant.SECKILL_CURRENT_COUNT+goodsId);
                resultMap.put("code", "1");
                resultMap.put("msg", "抢光啦");
                return resultMap;
            }

            CmCreditGoodsEntity goods = cmCreditGoodsDao.getById(goodsId);

            if (goods != null) {
                LOGGER.info("product stock is [{}] , cache length is [{}]", String.valueOf(goods.getStock()),
                            String.valueOf(goodCount));
            }

            // 判断秒杀是否已经结束
            if (goods.getSeckillEndTime().getTime() < new Date().getTime()) {
                resultMap.put("code", "5");//
                resultMap.put("msg", "当前秒杀结束啦~");
                //因为是事先减去一个库存 所以失败后，需要补充一个
                redisUtils.pushIntegerIntoRedisList(CmConstant.SECKILL_LEFT_STOCK_LIST + goodsId, 1);
                return resultMap;
            }
            // 如果不是秒杀商品
            if (goods.getIsSeckill() != 1) {
                resultMap.put("code", "3");
                resultMap.put("msg", "您错过了秒杀哦~");
                //因为是事先减去一个库存 所以失败后，需要补充一个
                redisUtils.pushIntegerIntoRedisList(CmConstant.SECKILL_LEFT_STOCK_LIST + goodsId, 1);
                return resultMap;
            }

            if (Strings.isNullOrEmpty(time) || "null".equalsIgnoreCase(time)) {
                redisUtils.setValueNew("prduct:seckill:time:" + goodsId,
                                       String.valueOf(goods.getSeckillStartTime().getTime()));
            }

            // 判断秒杀是否开始
            if (goods.getSeckillStartTime().getTime() > new Date().getTime()) {
                resultMap.put("code", "4");
                resultMap.put("msg", "还没有开始哦~");
                //因为是事先减去一个库存 所以失败后，需要补充一个
                redisUtils.pushIntegerIntoRedisList(CmConstant.SECKILL_LEFT_STOCK_LIST + goodsId, 1);

                return resultMap;
            }

            //商品可用的促销信息
            HashMap<String, HashMap> promotions = promotionProductService.getProductHitPromotions(goods.getId());
            if (null != promotions && !promotions.isEmpty() && promotions.containsKey("1")) {
                //用户是否命中新人专享
                if(!promotionProductService.checkUserIsHitNewUserPromotion(promotions,userId)){
                    resultMap.put("code", "-1");
                    resultMap.put("msg", promotions.get("1").get("msg"));
                    return resultMap;
                }
            }

            // 同一商品是否已经抢过一次
            QueryParams<CmSeckillBookedEntity> queryParams = new QueryParams<>();
            Map<String, Object> csMap = new HashMap<>();
            csMap.put("EQ_userId", userId);
            csMap.put("EQ_goodId", goodsId);
            queryParams.setSearchParams(csMap);
            List<CmSeckillBookedEntity> bookedList = secKillBoockedDao.queryAll(queryParams);
            if (bookedList != null && bookedList.size() > 0) {
                resultMap.put("code", "7");// 错过秒杀
                resultMap.put("msg", "您好像已经秒杀过了哦~");// 错过秒杀
                for (CmSeckillBookedEntity bookedEntity : bookedList) {
                    bookedEntity.setCreateTime(new Date());
                    secKillBoockedDao.update(bookedEntity);
                }
                redisUtils.increaseByKey(CmConstant.SECKILL_CURRENT_COUNT + goodsId);

                //因为是事先减去一个库存 所以失败后，需要补充一个
                redisUtils.pushIntegerIntoRedisList(CmConstant.SECKILL_LEFT_STOCK_LIST + goodsId, 1);
                return resultMap;
            } else {
                CmSeckillBookedEntity entity = new CmSeckillBookedEntity();
                entity.setUserPhone(phone);
                entity.setUserId(userId);
                entity.setGoodId(goodsId);
                entity.setCreateTime(new Date());
                entity.setRemindTime(goods.getSeckillEndTime());
                secKillBoockedDao.save(entity);
                resultMap.put("code", "2");// 抢单成功
                // resultMap.put("count", skStockObj);//抢单成功
                resultMap.put("msg", "抢单成功");// 抢单成功
                // 秒杀人数加1
                // killCount++;
                // redisUtils.increaseByKey(CmConstant.SECKILL_CURRENT_COUNT+goodsId);
                return resultMap;
            }

        } catch (Exception ex) {
            LOGGER.error("提交订单接口异常(OrderSubmit Error)！", ex);
            throw new ServiceRunException("提交数据异常!");
        }
    }

    /**
     * 判断服务是否具有控制逻辑
     *
     * @return 是否判断
     */
    public boolean isControlService() {

        return false;
    }

    /**
     * 判断服务是否需要记录日志
     *
     * @return 是否判断
     */
    public boolean isLogService() {

        return false;
    }

    /**
     * 判断服务是否需要监控
     *
     * @return 是否判断
     */
    public boolean isMonitorService() {

        return false;
    }

    /**
     * 事务回滚
     *
     * @return 事务回滚预留结果，暂无用途
     */
    public Object rollback() {

        return null;
    }

    /**
     * 事务提交
     */
    public void commit() {

    }
}
