package com.house365.ws.interfaces.rest;

import com.house365.beans.entity.CmCreditRecordEntity;
import com.house365.beans.entity.CmUserEntity;
import com.house365.rest.context.CmConstant;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.dao.interfaces.ICmUserDao;
import com.house365.ws.service.interfaces.ICmCreditRecordService;
import com.house365.ws.service.interfaces.ICmUserService;
import com.house365.ws.system.ReturnAppResult;
import com.house365.ws.util.CmCommonUtils;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Component("getRegisterCredits")
public class GetRegisterCreditsImpl implements IGetRegisterCredits {
    private static final Logger LOGGER = LoggerFactory.getLogger("InterfaceLog");

    @Autowired
    private ICmUserDao<CmUserEntity> userDao;

    @Autowired
    ICmCreditRecordService<CmCreditRecordEntity> icmCreditRecordService;

    @Autowired
    ICmUserService<CmUserEntity> iCmUserService;

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        Map<String, Object> resultMap = new HashMap<String, Object>();
        // 业务层统一处理
        try {
            String cityKey = CmCommonUtils.getCityFromMap(map);
            String userIdStr = ((String[]) map.get(CmConstant.USERID))[0];
            Integer useridType = Integer.parseInt(((String[]) map.get(CmConstant.USERID_TYPE))[0]);
            //先查看是否存在该用户，没有则说明是第一次注册，可以给予注册积分()
            CmUserEntity cmUserLocal = iCmUserService.getUserByUserIdCityKeyUserType(userIdStr, cityKey, useridType);
            if (cmUserLocal != null) {
                throw new ServiceRunException("用户已获取注册积分!");
            }

            CmUserEntity cmUser = iCmUserService.registUserByUserId(map);
            if (cmUser == null) {
                throw new ServiceRunException("用户中心用户不存在!");
            }

            Integer registerCredits = iCmUserService.transGetRegisterScore(cmUser, cityKey);

            // Integer resultCredits = iCmLotteryRuleService.transGetSignedScore(cmUser, cityKey);

            Map<String, Object> dataMap = new HashMap<>();
            dataMap.put("credits", registerCredits);
            dataMap.put("continuousSignCount", cmUser.getContinuousSignCount());
            dataMap.put("createTime", new Date());
            resultMap.put("data", dataMap);
            resultMap.put("result", ReturnAppResult.APP_SUCCESS.getResultCode());
            resultMap.put("msg", "获取成功！");
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            resultMap.put("result", ReturnAppResult.APP_FAIL.getResultCode());
            resultMap.put("msg", e.getMessage());
        }
        return JSONObject.fromObject(resultMap).toString();
    }

    @Override
    public boolean isControlService() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean isLogService() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean isMonitorService() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public Object rollback() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void commit() {
        // TODO Auto-generated method stub

    }

}
