package com.house365.ws.interfaces.rest;

import com.google.common.base.Strings;
import com.house365.beans.entity.CmCreditRecordEntity;
import com.house365.beans.entity.CmLotteryRuleEntity;
import com.house365.beans.entity.CmUserEntity;
import com.house365.rest.context.CmConstant;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.IllegalServiceInputException;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.service.interfaces.ICmCreditRecordService;
import com.house365.ws.service.interfaces.ICmLotteryRuleService;
import com.house365.ws.service.interfaces.ICmUserService;
import com.house365.ws.system.ReturnAppResult;
import com.house365.ws.util.CmCommonUtils;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Component("getLotteryCredits")
public class GetLotteryCreditsImpl implements IGetLotteryCredits {
    private static final Logger LOGGER = LoggerFactory.getLogger("InterfaceLog");

    @Autowired
    ICmLotteryRuleService<CmLotteryRuleEntity> iCmLotteryRuleService;

    @Autowired
    ICmCreditRecordService<CmCreditRecordEntity> icmCreditRecordService;

    @Autowired
    ICmUserService<CmUserEntity> iCmUserService;

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        Map<String, Object> resultMap = new HashMap<>();
        // 业务层统一处理
        try {
            if (!map.containsKey(CmConstant.USERID)) {
                resultMap.put("result", ReturnAppResult.APP_FAIL.getResultCode());
                resultMap.put("status", "0");
                resultMap.put("msg", "用户信息不存在!");
            } else {
                String userId = ((String[]) map.get(CmConstant.USERID))[0];
                Integer useridType = Integer.parseInt(((String[]) map.get(CmConstant.USERID_TYPE))[0]);
                String cityKey = CmCommonUtils.getCityFromMap(map);

                CmLotteryRuleEntity resultEntity = iCmLotteryRuleService.transGetSignedLotteryScore(userId, useridType,
                                                                                                    cityKey);

                Map<String, Object> dataMap = new HashMap<>();
                dataMap.put("ruleName", resultEntity.getCreditRuleName());
                dataMap.put("credits", resultEntity.getCredits());
                dataMap.put("userCredits", resultEntity.getUserCredits());
                dataMap.put("createTime", new Date());
                resultMap.put("data", dataMap);
                resultMap.put("result", ReturnAppResult.APP_SUCCESS.getResultCode());
                resultMap.put("msg", "恭喜你获得" + resultEntity.getCredits() + "淘房币");
            }
        } catch (Exception e) {
            if (e instanceof IllegalServiceInputException) {
                LOGGER.warn(e.getMessage());
            } else {
                LOGGER.error(e.getMessage(), e);
            }
            resultMap.put("result", ReturnAppResult.APP_FAIL.getResultCode());
            resultMap.put("status", e.getMessage());

            if(Strings.isNullOrEmpty(e.getMessage())){
                resultMap.put("msg", "好遗憾，没有抽中!");
            }else {
                switch (e.getMessage()) {
                    case "0":
                        resultMap.put("msg", "用户信息不存在!");
                        break;
                    case "1":
                        resultMap.put("msg", "抽奖规则获取失败!");
                        break;
                    case "2":
                        resultMap.put("msg", "您的淘房币余额不足!");
                        break;
                    case "3":
                        resultMap.put("msg", "好遗憾，没有抽中!");
                        break;
                    case "4":
                        resultMap.put("msg", "好遗憾，没有抽中!");
                        break;
                }
            }

        }
        return JSONObject.fromObject(resultMap).toString();
    }

    @Override
    public boolean isControlService() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean isLogService() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean isMonitorService() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public Object rollback() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void commit() {
        // TODO Auto-generated method stub

    }

}
