package com.house365.ws.interfaces.rest;

import com.house365.beans.entity.CmHouseCommentEntity;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.IllegalServiceParameterException;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.service.interfaces.ICmHouseCommentService;
import com.house365.ws.system.ReturnAppResult;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Date: 2017/6/12</p>
 *
 * @author XN
 * @version 1.0
 */
@Component("getHouseCommentInterface")
public class GetHouseCommentInterfaceImpl implements IGetHouseCommentInterface {

    /**
     * ID
     */
    public static final String COMMENT_ID = "commentId";
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(HouseCommentPraiseInterfaceImpl.class);
    /**
     * 参数列表
     */
    private static final String[] PARAMS = { COMMENT_ID};//CmConstant.USER_ID, CmConstant.USERID_TYPE, CmConstant.PRAISE


    @Autowired
    ICmHouseCommentService<CmHouseCommentEntity> cmHouseCommentService;


    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        Map<String,Object> response = new HashMap<String, Object>();

        // 业务校验统一入口
        try {
            checkInterfaceParameter(map);
        } catch (IllegalServiceParameterException e) {
            response.put("result",ReturnAppResult.APP_FAIL.getResultCode());
            response.put("msg",e.getMessage());
            return JSONObject.fromObject(response).toString();
        }
        // 业务层统一处理
        try {
            Map<String,Object> data = doBusiness(map);
            //设定返回值
            response.put("result",ReturnAppResult.APP_SUCCESS.getResultCode());
            response.put("msg",data.get("msg"));
            response.put("data",data.get("data"));
        } catch (ServiceRunException e) {
            response.put("result",ReturnAppResult.APP_FAIL.getResultCode());
            response.put("msg",e.getMessage());
        }

        return JSONObject.fromObject(response).toString();
    }

    /**
     * 业务层统校验自己所需参数是否存在
     *
     * @param map
     *            请求参数封装成Map对象
     * @return 统一返回参数
     * @author nizhengjia
     * @version [v1.0.0, 2015年5月6日]
     * @since [产品/模块版本](可选)
     */
    protected void checkInterfaceParameter(Map<String, Object> map) throws IllegalServiceParameterException {

        // 方法所需参数
        for (String str : PARAMS) {
            // 如果不存在跳出同时抛出相应异常
            if (!map.containsKey(str)) {
                LOGGER.error("业务入口参数异常：" + str+ "参数为空!");
                throw new IllegalServiceParameterException("业务入口参数异常：" + str + "参数为空!");
            }
        }

    }


    /**
     * 业务层统逻辑处理 获取抢客户信息
     *
     * @param
     * @return 统一返回参数
     * @author nizhengjia
     * @version [v1.0.0, 2015年5月6日]
     * @since [产品/模块版本](可选)
     */
    protected Map<String,Object> doBusiness(Map<String, Object> map) throws ServiceRunException {
        // 返回Json对象
        Map<String,Object> resultMap = new HashMap<String, Object>();
        try{

            String id = ((String[])map.get(COMMENT_ID))[0];

            //获取楼盘点评信息
            CmHouseCommentEntity houseCommentEntity = cmHouseCommentService.getById(Integer.valueOf(id));
            if(houseCommentEntity==null){
                resultMap.put("code", "1");
                resultMap.put("msg", "评论不存在！");
                return resultMap;
            }else{
                resultMap.put("result",ReturnAppResult.APP_SUCCESS.getResultCode());
                resultMap.put("msg","操作成功！");
                resultMap.put("data",houseCommentEntity);
            }
        } catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(e.getMessage());
            throw new ServiceRunException("网络不给力，请刷新重试");
        }
        return resultMap;
    }



    @Override
    public boolean isControlService() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean isLogService() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean isMonitorService() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public Object rollback() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void commit() {
        // TODO Auto-generated method stub

    }
}
