/*
 * Copyright (C), 2002-2015, 江苏三六五网络股份有限公司
 * FileName: ExchangeUserLoginInterfaceImpl.java
 * Author:   Administrator
 * Date:     2015年5月5日 下午2:57:41
 * Description: //模块目的、功能描述      
 * History: //修改记录
 * <author>      <time>      <version>    <desc>
 * 修改人姓名             修改时间            版本号                  描述
 */
package com.house365.ws.interfaces.rest;

import java.util.HashMap;
import java.util.Map;

import net.sf.json.JSONObject;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.house365.beans.entity.CmDeliveryAddressEntity;
import com.house365.beans.entity.CmUserEntity;
import com.house365.rest.context.CmConstant;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.IllegalServiceParameterException;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.service.interfaces.ICmDeliveryAddressService;
import com.house365.ws.service.interfaces.ICmUserService;
import com.house365.ws.system.ReturnAppResult;

/**
 * 〈一句话功能简述〉<br>
 * 获取送货信息接口
 *
 * @author Administrator
 * @version [版本号, 2015年5月5日]
 * @see [相关类/方法]（可选）
 * @since [产品/模块版本] （可选）
 */
@Component("getDeliveryInfoInterface")
public class GetDeliveryInfoInterfaceImpl implements IGetDeliveryInfoInterface {

    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(GetDeliveryInfoInterfaceImpl.class);
    
    @Autowired
    ICmUserService<CmUserEntity> iCmUserService;
    
    @Autowired
    private ICmDeliveryAddressService<CmDeliveryAddressEntity> deliveryAddressService;

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        Map<String, Object> resultMap = new HashMap<String, Object>();
        // 业务校验统一入口
        try {
            checkInterfaceParameter(map);
        } catch (IllegalServiceParameterException e) {
        	resultMap.put("result", ReturnAppResult.APP_FAIL.getResultCode());
        	resultMap.put("msg", e.getMessage());
            return JSONObject.fromObject(resultMap).toString();
        }
        // 业务层统一处理
        try {
        	resultMap = doBusiness(map);
        	resultMap.put("result",ReturnAppResult.APP_SUCCESS.getResultCode());
        	resultMap.put("msg",ReturnAppResult.APP_SUCCESS.getResultMessage());
        } catch (ServiceRunException e) {
        	resultMap.put("result",ReturnAppResult.APP_FAIL.getResultCode());
        	resultMap.put("msg",e.getMessage());
        }

        return JSONObject.fromObject(resultMap).toString();
    }

    /**
     * 
     * 业务层统校验自己所需参数是否存在
     *
     * @author nizhengjia
     * @version [v1.0.0, 2015年7月1日]
     * @param map 请求参数封装成Map对象
     * @return 统一返回参数
     * @since [产品/模块版本](可选)
     */
    protected void checkInterfaceParameter(Map<String, Object> map) throws IllegalServiceParameterException {
        // 方法所需参数
        for (String str : CmConstant.GetDeliveryInfo) {
            // 如果不存在跳出 同时抛出相应异常
            if (!map.containsKey(str)) {
                LOGGER.error("业务入口参数异常：" + str + "参数为空!");
                throw new IllegalServiceParameterException("业务入口参数异常：" + str + "参数为空!");
            }

        }
    }

    /**
     * 
     * 业务层统逻辑处理
     *
     * @author nizhengjia
     * @version [v1.0.0, 2015年8月18日]
     * @param
     * @return 统一返回参数
     * @throws ServiceRunException
     * @since [产品/模块版本](可选)
     */
    protected Map<String, Object> doBusiness(Map<String, Object> map) throws ServiceRunException {
        // 返回Json对象
        //House365RestObject<CmDeliveryAddressEntity> restObject = new House365RestObject<CmDeliveryAddressEntity>();
        Map<String, Object> resultMap = new HashMap<String, Object>();
        CmDeliveryAddressEntity deliveryAddressEntity = new CmDeliveryAddressEntity();
        try {
        	
            String userId = ((String[])map.get(CmConstant.USER_ID))[0];
            // 请求的页码
            Integer currentPage = Integer.parseInt(((String[]) map.get(CmConstant.PAGE))[0]);
            // 每页数据条数
            Integer pageSize = Integer.parseInt(((String[]) map.get(CmConstant.PAGESIZE))[0]);
            // 分页表达式
           // Integer page = (currentPage - 1) * pageSize;
            // 查询参数
            String cityKey = ((String[]) map.get(CmConstant.USER_CITY_KEY))[0];
            Integer useridType = Integer.parseInt(((String[]) map.get(CmConstant.USERID_TYPE))[0]);
            CmUserEntity cmUser = iCmUserService.getUserByUserIdCityKeyUserType(userId, cityKey, useridType);
        	if(cmUser!=null)
        	{
        		//获取送货信息接口
        		deliveryAddressEntity = deliveryAddressService.getByUserId(cmUser.getId());
        		resultMap.put("data",deliveryAddressEntity);
        	}
            return resultMap;
        } catch (Exception ex) {
        	ex.printStackTrace();
            LOGGER.error("获取送货信息异常(Get GetDeliveryInfo Error)！");
            throw new ServiceRunException("网络不给力，请刷新重试");
        }
    }


    /**
     * 判断服务是否具有控制逻辑
     * 
     * @return 是否判断
     */
    public boolean isControlService() {

        return false;
    }

    /**
     * 判断服务是否需要记录日志
     * 
     * @return 是否判断
     */
    public boolean isLogService() {

        return false;
    }

    /**
     * 判断服务是否需要监控
     * 
     * @return 是否判断
     */
    public boolean isMonitorService() {

        return false;
    }

    /**
     * 事务回滚
     * 
     * @return 事务回滚预留结果，暂无用途
     */
    public Object rollback() {

        return null;
    }

    /**
     * 事务提交
     */
    public void commit() {

    }
}
