package com.house365.ws.interfaces.rest;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import com.house365.beans.entity.CmCreditRuleEntity;
import com.house365.beans.entity.CmLotteryRuleEntity;
import com.house365.beans.system.Page;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.CmConstant;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.IllegalServiceParameterException;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.service.interfaces.ICmCreditRuleService;
import com.house365.ws.system.ReturnAppResult;

@Component("getCreditRules")
public class GetCreditRulesImpl implements IGetCreditRules {
    
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(GetCreditRulesImpl.class);
    
  
    /**
     * 参数列表
     */
    private static final String[] PARAMS = { };
    
    
    @Autowired
    ICmCreditRuleService<CmCreditRuleEntity> iCmCreditRuleService;
    
    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
     // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        House365RestResponse<CmCreditRuleEntity> response = new House365RestResponse<CmCreditRuleEntity>();

        // 业务校验统一入口
        try {
            checkInterfaceParameter(map);
        } catch (IllegalServiceParameterException e) {
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg(e.getMessage());
            return JSONObject.fromObject(response).toString();
        }

        // 业务层统一处理
        try {
            House365RestObject<CmCreditRuleEntity> data = doBusiness(map);
            response.setData(data);
            response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
            response.setMsg(ReturnAppResult.APP_SUCCESS.getResultMessage());
        } catch (ServiceRunException e) {
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg(e.getMessage());
        }

        return JSONObject.fromObject(response).toString();
    }
    
    
    /**
     * 业务层统校验自己所需参数是否存在
     *
     * @param map
     *            请求参数封装成Map对象
     * @return 统一返回参数
     * @author nizhengjia
     * @version [v1.0.0, 2015年5月6日]
     * @since [产品/模块版本](可选)
     */
    protected void checkInterfaceParameter(Map<String, Object> map) throws IllegalServiceParameterException {

        // 方法所需参数
        for (String str : PARAMS) { 
              // 如果不存在跳出同时抛出相应异常 
              if (!map.containsKey(str)) { 
                  LOGGER.error("业务入口参数异常：" + str+ "参数为空!"); 
                  throw new IllegalServiceParameterException("业务入口参数异常：" + str + "参数为空!"); 
              } 
        }
        
    }

    /**
     * 业务层统逻辑处理 获取抢客户信息
     *
     * @param
     * @return 统一返回参数
     * @author nizhengjia
     * @version [v1.0.0, 2015年5月6日]
     * @since [产品/模块版本](可选)
     */
    protected House365RestObject<CmCreditRuleEntity> doBusiness(Map<String, Object> map) throws ServiceRunException {
        // 返回Json对象
        House365RestObject<CmCreditRuleEntity> restObject = new House365RestObject<CmCreditRuleEntity>();
       try{
           // String cityId = ((String[]) map.get(CmConstant.CITYID))[0];
           String ruleId=null;
           if (!StringUtils.isEmpty(map.get(CmConstant.RULEID))) {
               ruleId = ((String[]) map.get(CmConstant.RULEID))[0];
           }
           // 查询参数
           Map<String, Object> param = new HashMap<String, Object>();
           //
           if(ruleId!=null){
               param.put("EQ_id", ruleId);
           }
           Page page = new Page();
           page.setCurrentPage(0);
           page.setPages(9999);
           QueryParams<CmCreditRuleEntity> queryParam = new QueryParams<CmCreditRuleEntity>();
           queryParam.setPaging(page);
           queryParam.setSearchParams(param);
           List<CmCreditRuleEntity> cmList = iCmCreditRuleService.queryByPage(queryParam);
           restObject.setList(cmList);
        } catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new ServiceRunException("网络不给力，请刷新重试");
        }
        return restObject;
    }

    @Override
    public boolean isControlService() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean isLogService() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean isMonitorService() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public Object rollback() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void commit() {
        // TODO Auto-generated method stub

    }

}
