package com.house365.ws.interfaces.rest;

import com.house365.beans.entity.CmHouseCommentReplyEntity;
import com.house365.beans.entity.CmOrderEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.CmConstant;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.IllegalServiceParameterException;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.service.interfaces.ICmHouseCommentReplyService;
import com.house365.ws.system.ReturnAppResult;
import net.sf.json.JSONObject;
import org.jboss.netty.util.internal.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.text.SimpleDateFormat;
import java.util.*;

@Service("getCommentAndReplyInfo")
public class GetCommentAndReplyInfoImpl implements IGetCommentAndReplyInfo{

    private static final Logger LOGGER = LoggerFactory.getLogger(GetHouseByIdInterfaceImpl.class);

    @Autowired
    ICmHouseCommentReplyService icmhousecommentreplyservice;

    public static final String STARTDATE = "startDate";

    public static final String ENDDATE = "endDate";

    public static final String[] CommentAndReplyInfo = {STARTDATE, ENDDATE};

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {

        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        House365RestResponse<CmHouseCommentReplyEntity> response = new House365RestResponse<CmHouseCommentReplyEntity>();
        // 业务校验统一入口
//        try {
//            checkInterfaceParameter(map);
//        } catch (IllegalServiceParameterException e) {
//            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
//            response.setMsg(e.getMessage());
//            return JSONObject.fromObject(response).toString();
//        }
        // 业务层统一处理
        try {
            House365RestObject<CmHouseCommentReplyEntity> data = doBusiness(map);
            response.setData(data);
//            if (StringUtils.isEmpty(data.getTotal())) {
//                response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
//                response.setMsg("操作失败");
//            } else {
                response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
                response.setMsg("操作成功");
//            }

        } catch (ServiceRunException e) {
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg(e.getMessage());
        }

        return JSONObject.fromObject(response).toString();
    }

    protected House365RestObject<CmHouseCommentReplyEntity> doBusiness(Map<String, Object> map) throws ServiceRunException {
        // 返回Json对象
        House365RestObject<CmHouseCommentReplyEntity> restObject = new House365RestObject<>();
        List<CmHouseCommentReplyEntity> entityList = new ArrayList<>();
        QueryParams<CmHouseCommentReplyEntity> queryParams = new QueryParams<>();
        String beginTime = map.containsKey("startTime") ? ((String[])map.get("startTime"))[0] : "";
        String enTime = map.containsKey("endTime") ? ((String[])map.get("endTime"))[0] : "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar ca = Calendar.getInstance();
        ca.setTime(new Date());
        ca.add(Calendar.DAY_OF_YEAR, -1);
        Date lastday = ca.getTime();
        Map<String, Object> qmap = new HashMap<>();
        if(StringUtils.isEmpty(beginTime) && StringUtils.isEmpty(enTime)){
            String statTime = sdf.format(lastday);
            statTime += " 00:00:01";
            String endTime = sdf.format(lastday);
            endTime = endTime + " 23:59:59";
            qmap.put("GT_StartTime", statTime);
            qmap.put("LT_EndTime", endTime);
            queryParams.setSearchParams(qmap);
        }else{
            qmap.put("GT_StartTime", beginTime);
            qmap.put("LT_EndTime", enTime);
            queryParams.setSearchParams(qmap);
        }
        try {
            List<CmHouseCommentReplyEntity> list = icmhousecommentreplyservice.queryAllByLastDay(queryParams);
            String result = "0";
            restObject.setList(list);
            if(list!=null){
                restObject.setTotal(String.valueOf(list.size()));
            }
            return restObject;
        } catch (Exception ex) {
            LOGGER.warn("积分商城-获取楼盘详细信息数据异常！", ex);
            throw new ServiceRunException("网络不给力，请刷新重试");
        }
    }



    /**
     * 业务层统校验自己所需参数是否存在
     *
     * @param
     * @return 统一返回参数
     * @author yangyang
     * @version [v1.0.0, 2015年8月18日]
     * @since [产品/模块版本](可选)
     */
    protected void checkInterfaceParameter(Map<String, Object> map) throws IllegalServiceParameterException {

        // 方法所需参数
        for (String str : CommentAndReplyInfo) {
            // 如果不存在跳出 同时抛出相应异常
            if (!map.containsKey(str)) {
                LOGGER.error("业务入口参数异常：" + str + "参数为空!");
                throw new IllegalServiceParameterException("业务入口参数异常：" + str + "参数为空!");
            }

        }
    }

    @Override
    public boolean isControlService() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean isLogService() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean isMonitorService() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public Object rollback() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void commit() {
        // TODO Auto-generated method stub

    }



}
