package com.house365.ws.interfaces.rest;

import com.google.common.base.Strings;
import com.house365.beans.entity.CmCreditRecordEntity;
import com.house365.beans.entity.CmUserEntity;
import com.house365.rest.context.CmConstant;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.service.interfaces.ICmCreditRecordService;
import com.house365.ws.service.interfaces.ICmUserService;
import com.house365.ws.system.ReturnAppResult;
import com.house365.ws.util.JsonUtil;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Date: 16/4/11</p>
 *
 * @author XN
 * @version 1.0
 */
@Service("creditInterface")
public class CreditInterface implements ICreditInterface {

    private static final Logger LOGGER = LoggerFactory.getLogger("InterfaceLog");

    @Autowired
    private ICmCreditRecordService cmCreditRecordService;

    @Autowired
    ICmUserService<CmUserEntity> iCmUserService;

    @Override
    public Object addCreditByQuestion(Map<String, Object> map) throws ServiceRunException {
        JSONObject mergedJSON = new JSONObject();
        try {

            if (!map.containsKey(CmConstant.USERID) || map.get(CmConstant.USERID) == null) {
                mergedJSON.put("result", ReturnAppResult.APP_FAIL.getResultCode());
                mergedJSON.put("msg", "用户参数不存在!");
                return mergedJSON.toString();
            }

            if (!map.containsKey("questionId") || map.get("questionId") == null) {
                mergedJSON.put("result", ReturnAppResult.APP_FAIL.getResultCode());
                mergedJSON.put("msg", "问题ID参数不存在!");
                return mergedJSON.toString();
            }

            CmUserEntity cmUser = iCmUserService.registUserByUserId(map);
            if (cmUser == null) {
                throw new ServiceRunException("用户中心用户不存在!");
            }

            String questionId = ((String[]) map.get("questionId"))[0];
            questionId = Strings.isNullOrEmpty(questionId) ? "" : questionId;

            CmCreditRecordEntity cmCreditRecordEntity = cmCreditRecordService.transAddCreditByQuestion(cmUser,
                                                                                                       questionId);
            if(cmCreditRecordEntity!=null) {
                mergedJSON.put("credit", cmCreditRecordEntity.getAmount());
                mergedJSON.put("totalCredit", cmCreditRecordEntity.getRemainingAmount());
            }else{
                mergedJSON.put("result", ReturnAppResult.APP_FAIL.getResultCode());
                mergedJSON.put("msg", ReturnAppResult.APP_FAIL.getResultMessage());
                return mergedJSON.toString();
            }

        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            mergedJSON.put("result", ReturnAppResult.APP_FAIL.getResultCode());
            mergedJSON.put("msg", ReturnAppResult.APP_FAIL.getResultMessage());
        }
        JSONObject resultJSON = JsonUtil.getExecuteOKJson(mergedJSON);
        return resultJSON.toString();
    }


    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }
}
