package com.house365.ws.interfaces.rest;

import com.google.common.base.Strings;
import com.house365.beans.entity.CmCreditRecordEntity;
import com.house365.beans.entity.CmUserEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.CmConstant;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.service.interfaces.ICmCreditRecordService;
import com.house365.ws.service.interfaces.ICmUserService;
import com.house365.ws.system.ReturnAppResult;
import com.house365.ws.util.JsonUtil;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>Title: 业主社区发帖回帖加积分</p>
 * <p>Description: </p>
 * <p>Date: 16/8/26</p>
 *
 * @author XN
 * @version 1.0
 */
@Component("bbsCredits")
public class BBSCreditImpl implements IBBSCredit {
    private static final Logger LOGGER = LoggerFactory.getLogger("InterfaceLog");

    @Autowired
    private ICmCreditRecordService cmCreditRecordService;

    @Autowired
    ICmUserService<CmUserEntity> iCmUserService;

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        JSONObject mergedJSON = new JSONObject();
        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        try {

            if (!map.containsKey(CmConstant.USERID) || map.get(CmConstant.USERID) == null) {
                mergedJSON.put("result", ReturnAppResult.APP_FAIL.getResultCode());
                mergedJSON.put("msg", "用户参数不存在!");
                return mergedJSON.toString();
            }

            CmUserEntity cmUser = iCmUserService.registUserByUserId(map);
            if (cmUser == null) {
                throw new ServiceRunException("用户中心用户不存在!");
            }

            CmCreditRecordEntity cmCreditRecordEntity = cmCreditRecordService.transAddCreditByBbs(cmUser);

            if (cmCreditRecordEntity != null) {
                mergedJSON.put("credit", cmCreditRecordEntity.getAmount());
                mergedJSON.put("totalCredit", cmCreditRecordEntity.getRemainingAmount());
            } else {
                mergedJSON.put("result", ReturnAppResult.APP_FAIL.getResultCode());
                mergedJSON.put("msg", ReturnAppResult.APP_FAIL.getResultMessage());
                return mergedJSON.toString();
            }

        } catch (Exception e) {
            LOGGER.error(e.getMessage());
            mergedJSON.put("result", ReturnAppResult.APP_FAIL.getResultCode());
            mergedJSON.put("msg", ReturnAppResult.APP_FAIL.getResultMessage());
            return mergedJSON.toString();
        }
        JSONObject resultJSON = JsonUtil.getExecuteOKJson(mergedJSON);
        return resultJSON.toString();
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }
}
