/*
 * Copyright (C), 2002-2015, 江苏三六五网络股份有限公司
 * FileName: IfRegInterfaceImpl.java
 * Author:   duhui
 * Date:     2015年1月24日 下午4:24:27
 * Description:     
 * History: 
 * <author>      <time>      <version>    <desc>
 * 修改人姓名                          修改时间                        版本号                                 描述
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.po.IfRegPo;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.context.ServiceConstant;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.IfRegListRequest;
import com.house365.ws.beans.request.IfRegRequest;
import com.house365.ws.beans.response.IfRegListResponse;
import com.house365.ws.beans.response.IfRegResponse;
import com.house365.ws.interfaces.server.IIfRegInterface;
import com.house365.ws.service.interfaces.IIfRegService;
import com.house365.ws.system.House365InterfaceResponse;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 接口发布接口实现
 *
 * @author duhui
 * @version [v1.0.0, 2015年1月24日]
 * @see [相关类/方法]（可选）
 * @since [产品/模块版本] （可选）
 */
@Component("ifRegInterface")
public class IfRegInterfaceImpl implements IIfRegInterface {

    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(IfRegInterfaceImpl.class);

    /**
     * 获取服务参数
     *
     * @return 与服务绑定的参数
     */
    private Parameter parameter;

    /**
     * 接口服务对象
     */
    @Autowired
    private IIfRegService<IfRegPo> ifRegService;

    /**
     * 根据查询条件获取接口列表
     */
    @Override
    public IfRegListResponse getIfRegList(IfRegListRequest request) {
        IfRegListResponse response = new IfRegListResponse();
        try {
            QueryParams<IfRegPo> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<IfRegPo> ifReg = ifRegService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(ifReg);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 接口添加
     */
    @Override
    public IfRegResponse addIfReg(IfRegRequest request) {
        IfRegResponse response = new IfRegResponse();
        try {
            IfRegPo ifRegPo = request.getIfRegPo();
            Integer id = ifRegService.save(ifRegPo);
            ifRegPo.setId(id);
            response.setIfRegPo(ifRegPo);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 接口删除
     */
    @Override
    public IfRegResponse deleteIfRegById(Integer id) {
        IfRegResponse response = new IfRegResponse();
        try {
            ifRegService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 接口修改
     */
    @Override
    public IfRegResponse updateIfReg(IfRegRequest request) {
        IfRegResponse response = new IfRegResponse();
        try {
            IfRegPo ifRegPo = request.getIfRegPo();
            ifRegService.update(ifRegPo);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 接口详情
     */
    @Override
    public IfRegResponse getIfRegById(Integer id) {
        IfRegResponse response = new IfRegResponse();
        try {
            IfRegPo ifRegPo = ifRegService.getById(id);
            response.setIfRegPo(ifRegPo);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 取得公共容器服务
     */
    @Override
    public List<IfRegPo> getIfRegServiceReg(String serviceCode, String serviceName) {
        return ifRegService.getIfRegByServiceCodeAndServiceName(serviceCode, serviceName);
    }

    /**
     * 执行服务
     *
     * @param parameter 服务输入，不包含服务配置和控制信息
     * @return 执行结果，目前为对json的封装，可以为null
     * @throws ServiceRunException 如果运行的服务发生异常则抛出服务运行时异常
     */
    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        House365InterfaceResponse<IfRegPo> response = new House365InterfaceResponse<>();
        try {
            List<IfRegPo> ifRegPoList = ifRegService
                    .getIfRegByServiceCodeAndServiceName((String) parameter.getArg(ServiceConstant.SERVICE_CODE),
                            (String) parameter.getArg(ServiceConstant.SERVICE_NAME));
            response.setObjectList(ifRegPoList);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }

        return response;
    }

    /**
     * 获取服务参数
     *
     * @return 与服务绑定的参数
     */
    public Parameter getParameter() {

        return parameter;
    }

    /**
     * 设置服务参数
     *
     * @param parameter 服务参数
     * @param initText  服务参数的初始化信息，由服务自身负责解析
     */
    public void setParameter(Parameter parameter, String initText) {

        this.parameter = parameter;
    }

    /**
     * 判断服务是否具有控制逻辑
     *
     * @return 是否判断
     */
    @Override
    public boolean isControlService() {
        return false;
    }

    /**
     * 判断服务是否需要记录日志
     *
     * @return 是否判断
     */
    @Override
    public boolean isLogService() {
        return false;
    }

    /**
     * 判断服务是否需要监控
     *
     * @return 是否判断
     */
    @Override
    public boolean isMonitorService() {
        return false;
    }

    /**
     * 事务回滚
     *
     * @return 事务回滚预留结果，暂无用途
     */
    @Override
    public Object rollback() {
        return null;
    }

    /**
     * 事务提交
     */
    @Override
    public void commit() {

    }
}
