/**
 * Description: CmRemoveGoodsWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:20
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmRemoveGoodsEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmRemoveGoodsListRequest;
import com.house365.ws.beans.request.CmRemoveGoodsRequest;
import com.house365.ws.beans.response.CmRemoveGoodsListResponse;
import com.house365.ws.beans.response.CmRemoveGoodsResponse;
import com.house365.ws.interfaces.server.ICmRemoveGoods;
import com.house365.ws.service.interfaces.ICmRemoveGoodsService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmRemoveGoodsWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Service("cmRemoveGoods")
public class CmRemoveGoodsImpl implements ICmRemoveGoods {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory
            .getLogger(CmRemoveGoodsImpl.class);

    /**
     * CmRemoveGoods服务对象
     */
    @Autowired
    private ICmRemoveGoodsService<CmRemoveGoodsEntity> cmRemoveGoodsService;

    /**
     * CmRemoveGoods列表查询
     *
     * @param request CmRemoveGoods列表查询请求
     * @return CmRemoveGoods列表查询响应
     */
    @Override
    public CmRemoveGoodsListResponse getCmRemoveGoodsList(CmRemoveGoodsListRequest request) {
        CmRemoveGoodsListResponse response = new CmRemoveGoodsListResponse();
        try {
            QueryParams<CmRemoveGoodsEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            List<CmRemoveGoodsEntity> cmRemoveGoodss = cmRemoveGoodsService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmRemoveGoodss);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmRemoveGoods
     *
     * @param request CmRemoveGoods请求
     * @return 保存CmRemoveGoods响应
     */
    @Override
    public CmRemoveGoodsResponse addCmRemoveGoods(CmRemoveGoodsRequest request) {
        CmRemoveGoodsResponse response = new CmRemoveGoodsResponse();
        try {
            CmRemoveGoodsEntity entity = request.getEntity();
            cmRemoveGoodsService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmRemoveGoods通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmRemoveGoods响应
     */
    @Override
    public CmRemoveGoodsResponse deleteCmRemoveGoodsById(Integer id) {
        CmRemoveGoodsResponse response = new CmRemoveGoodsResponse();
        try {
            cmRemoveGoodsService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmRemoveGoods
     *
     * @param request 修改CmRemoveGoods请求
     * @return 修改CmRemoveGoods响应
     */
    @Override
    public CmRemoveGoodsResponse updateCmRemoveGoods(CmRemoveGoodsRequest request) {
        CmRemoveGoodsResponse response = new CmRemoveGoodsResponse();
        try {
            cmRemoveGoodsService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmRemoveGoods
     *
     * @param id 唯一标识
     * @return 通过ID获取CmRemoveGoods响应
     */
    @Override
    public CmRemoveGoodsResponse getCmRemoveGoodsById(Integer id) {
        CmRemoveGoodsResponse response = new CmRemoveGoodsResponse();
        try {
            CmRemoveGoodsEntity entity = cmRemoveGoodsService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
