/**
 * Description: CmPromotionWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-01 上午 10:52:43
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-01   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmPromotionEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmPromotionListRequest;
import com.house365.ws.beans.request.CmPromotionRequest;
import com.house365.ws.beans.response.CmPromotionListResponse;
import com.house365.ws.beans.response.CmPromotionResponse;
import com.house365.ws.interfaces.server.ICmPromotion;
import com.house365.ws.service.interfaces.ICmPromotionService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmPromotionWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-01
 * @see
 * @since 1.0
 */
@Service("cmPromotion")
public class CmPromotionImpl implements ICmPromotion {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmPromotionImpl.class);

    /**
     * CmPromotion服务对象
     */
    @Autowired
    private ICmPromotionService<CmPromotionEntity> cmPromotionService;

    /**
     * CmPromotion列表查询
     *
     * @param request CmPromotion列表查询请求
     * @return CmPromotion列表查询响应
     */
    @Override
    public CmPromotionListResponse getCmPromotionList(CmPromotionListRequest request) {
        CmPromotionListResponse response = new CmPromotionListResponse();
        try {
            QueryParams<CmPromotionEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<CmPromotionEntity> cmPromotions = cmPromotionService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmPromotions);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmPromotion
     *
     * @param request CmPromotion请求
     * @return 保存CmPromotion响应
     */
    @Override
    public CmPromotionResponse addCmPromotion(CmPromotionRequest request) {
        CmPromotionResponse response = new CmPromotionResponse();
        try {
            CmPromotionEntity entity = request.getEntity();
            cmPromotionService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmPromotion通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmPromotion响应
     */
    @Override
    public CmPromotionResponse deleteCmPromotionById(Integer id) {
        CmPromotionResponse response = new CmPromotionResponse();
        try {
            cmPromotionService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmPromotion
     *
     * @param request 修改CmPromotion请求
     * @return 修改CmPromotion响应
     */
    @Override
    public CmPromotionResponse updateCmPromotion(CmPromotionRequest request) {
        CmPromotionResponse response = new CmPromotionResponse();
        try {
            cmPromotionService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmPromotion
     *
     * @param id 唯一标识
     * @return 通过ID获取CmPromotion响应
     */
    @Override
    public CmPromotionResponse getCmPromotionById(Integer id) {
        CmPromotionResponse response = new CmPromotionResponse();
        try {
            CmPromotionEntity entity = cmPromotionService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
