/**
 * Description: CmPromotionConfigWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-01 上午 10:52:47
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-01   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmPromotionConfigEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmPromotionConfigListRequest;
import com.house365.ws.beans.request.CmPromotionConfigRequest;
import com.house365.ws.beans.response.CmPromotionConfigListResponse;
import com.house365.ws.beans.response.CmPromotionConfigResponse;
import com.house365.ws.interfaces.server.ICmPromotionConfig;
import com.house365.ws.service.interfaces.ICmPromotionConfigService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmPromotionConfigWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-01
 * @see
 * @since 1.0
 */
@Service("cmPromotionConfig")
public class CmPromotionConfigImpl implements ICmPromotionConfig {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmPromotionConfigImpl.class);

    /**
     * CmPromotionConfig服务对象
     */
    @Autowired
    private ICmPromotionConfigService<CmPromotionConfigEntity> cmPromotionConfigService;

    /**
     * CmPromotionConfig列表查询
     *
     * @param request CmPromotionConfig列表查询请求
     * @return CmPromotionConfig列表查询响应
     */
    @Override
    public CmPromotionConfigListResponse getCmPromotionConfigList(CmPromotionConfigListRequest request) {
        CmPromotionConfigListResponse response = new CmPromotionConfigListResponse();
        try {
            QueryParams<CmPromotionConfigEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<CmPromotionConfigEntity> cmPromotionConfigs = cmPromotionConfigService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmPromotionConfigs);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmPromotionConfig
     *
     * @param request CmPromotionConfig请求
     * @return 保存CmPromotionConfig响应
     */
    @Override
    public CmPromotionConfigResponse addCmPromotionConfig(CmPromotionConfigRequest request) {
        CmPromotionConfigResponse response = new CmPromotionConfigResponse();
        try {
            CmPromotionConfigEntity entity = request.getEntity();
            cmPromotionConfigService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmPromotionConfig通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmPromotionConfig响应
     */
    @Override
    public CmPromotionConfigResponse deleteCmPromotionConfigById(Integer id) {
        CmPromotionConfigResponse response = new CmPromotionConfigResponse();
        try {
            cmPromotionConfigService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmPromotionConfig
     *
     * @param request 修改CmPromotionConfig请求
     * @return 修改CmPromotionConfig响应
     */
    @Override
    public CmPromotionConfigResponse updateCmPromotionConfig(CmPromotionConfigRequest request) {
        CmPromotionConfigResponse response = new CmPromotionConfigResponse();
        try {
            cmPromotionConfigService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmPromotionConfig
     *
     * @param id 唯一标识
     * @return 通过ID获取CmPromotionConfig响应
     */
    @Override
    public CmPromotionConfigResponse getCmPromotionConfigById(Integer id) {
        CmPromotionConfigResponse response = new CmPromotionConfigResponse();
        try {
            CmPromotionConfigEntity entity = cmPromotionConfigService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
