/**
 * Description: CmProductStatWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-03-16 下午 17:11:49
 * <p/>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-03-16   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmCreditGoodsEntity;
import com.house365.beans.entity.CmProductStatEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmProductStatListRequest;
import com.house365.ws.beans.request.CmProductStatRequest;
import com.house365.ws.beans.response.CmProductStatListResponse;
import com.house365.ws.beans.response.CmProductStatResponse;
import com.house365.ws.interfaces.server.ICmProductStat;
import com.house365.ws.service.interfaces.ICmProductStatService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmProductStatWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-03-16
 * @see
 * @since 1.0
 */
@Service("cmProductStat")
public class CmProductStatImpl implements ICmProductStat {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmProductStatImpl.class);

    /**
     * CmProductStat服务对象
     */
    @Autowired
    private ICmProductStatService<CmProductStatEntity> cmProductStatService;

    @Override
    public void saveOrUpdate(CmCreditGoodsEntity goodsEntity) {
        cmProductStatService.saveOrUpdate(goodsEntity);
    }

    @Override
    public void refreshTask() {
        cmProductStatService.refreshTask();
    }

    /**
     * CmProductStat列表查询
     *
     * @param request CmProductStat列表查询请求
     * @return CmProductStat列表查询响应
     */
    @Override
    public CmProductStatListResponse getCmProductStatList(CmProductStatListRequest request) {
        CmProductStatListResponse response = new CmProductStatListResponse();
        try {
            QueryParams<CmProductStatEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<CmProductStatEntity> cmProductStats = cmProductStatService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmProductStats);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmProductStat
     *
     * @param request CmProductStat请求
     * @return 保存CmProductStat响应
     */
    @Override
    public CmProductStatResponse addCmProductStat(CmProductStatRequest request) {
        CmProductStatResponse response = new CmProductStatResponse();
        try {
            CmProductStatEntity entity = request.getEntity();
            cmProductStatService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmProductStat通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmProductStat响应
     */
    @Override
    public CmProductStatResponse deleteCmProductStatById(Integer id) {
        CmProductStatResponse response = new CmProductStatResponse();
        try {
            cmProductStatService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmProductStat
     *
     * @param request 修改CmProductStat请求
     * @return 修改CmProductStat响应
     */
    @Override
    public CmProductStatResponse updateCmProductStat(CmProductStatRequest request) {
        CmProductStatResponse response = new CmProductStatResponse();
        try {
            cmProductStatService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmProductStat
     *
     * @param id 唯一标识
     * @return 通过ID获取CmProductStat响应
     */
    @Override
    public CmProductStatResponse getCmProductStatById(Integer id) {
        CmProductStatResponse response = new CmProductStatResponse();
        try {
            CmProductStatEntity entity = cmProductStatService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 按城市统计
     *
     * @return
     */
    @Override
    public List<CmProductStatEntity> statByCity() {
        return cmProductStatService.statByCity();
    }

    @Override
    public List<CmProductStatEntity> statByDate(String cityName) {
        return cmProductStatService.statByDate(cityName);
    }

    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
