/**
 * Description: CmPraiseWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:19
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmPraiseEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmPraiseListRequest;
import com.house365.ws.beans.request.CmPraiseRequest;
import com.house365.ws.beans.response.CmPraiseListResponse;
import com.house365.ws.beans.response.CmPraiseResponse;
import com.house365.ws.interfaces.server.ICmPraise;
import com.house365.ws.service.interfaces.ICmPraiseService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmPraiseWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Service("cmPraise")
public class CmPraiseImpl implements ICmPraise {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmPraiseImpl.class);

    /**
     * CmPraise服务对象
     */
    @Autowired
    private ICmPraiseService<CmPraiseEntity> cmPraiseService;

    /**
     * CmPraise列表查询
     *
     * @param request CmPraise列表查询请求
     * @return CmPraise列表查询响应
     */
    @Override
    public CmPraiseListResponse getCmPraiseList(CmPraiseListRequest request) {
        CmPraiseListResponse response = new CmPraiseListResponse();
        try {
            QueryParams<CmPraiseEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            List<CmPraiseEntity> cmPraises = cmPraiseService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmPraises);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmPraise
     *
     * @param request CmPraise请求
     * @return 保存CmPraise响应
     */
    @Override
    public CmPraiseResponse addCmPraise(CmPraiseRequest request) {
        CmPraiseResponse response = new CmPraiseResponse();
        try {
            CmPraiseEntity entity = request.getEntity();
            cmPraiseService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmPraise通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmPraise响应
     */
    @Override
    public CmPraiseResponse deleteCmPraiseById(Integer id) {
        CmPraiseResponse response = new CmPraiseResponse();
        try {
            cmPraiseService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmPraise
     *
     * @param request 修改CmPraise请求
     * @return 修改CmPraise响应
     */
    @Override
    public CmPraiseResponse updateCmPraise(CmPraiseRequest request) {
        CmPraiseResponse response = new CmPraiseResponse();
        try {
            cmPraiseService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmPraise
     *
     * @param id 唯一标识
     * @return 通过ID获取CmPraise响应
     */
    @Override
    public CmPraiseResponse getCmPraiseById(Integer id) {
        CmPraiseResponse response = new CmPraiseResponse();
        try {
            CmPraiseEntity entity = cmPraiseService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
