/**
 * Description: CmLotteryRuleWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-19 上午 11:24:24
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-19   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmLotteryRuleEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmLotteryRuleListRequest;
import com.house365.ws.beans.request.CmLotteryRuleRequest;
import com.house365.ws.beans.response.CmLotteryRuleListResponse;
import com.house365.ws.beans.response.CmLotteryRuleResponse;
import com.house365.ws.interfaces.server.ICmLotteryRule;
import com.house365.ws.service.interfaces.ICmLotteryRuleService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmLotteryRuleWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-19
 * @see
 * @since 1.0
 */
@Service("cmLotteryRule")
public class CmLotteryRuleImpl implements ICmLotteryRule {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmLotteryRuleImpl.class);

    /**
     * CmLotteryRule服务对象
     */
    @Autowired
    private ICmLotteryRuleService<CmLotteryRuleEntity> cmLotteryRuleService;

    /**
     * CmLotteryRule列表查询
     *
     * @param request CmLotteryRule列表查询请求
     * @return CmLotteryRule列表查询响应
     */
    @Override
    public CmLotteryRuleListResponse getCmLotteryRuleList(CmLotteryRuleListRequest request) {
        CmLotteryRuleListResponse response = new CmLotteryRuleListResponse();
        try {
            QueryParams<CmLotteryRuleEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            List<CmLotteryRuleEntity> cmLotteryRules = cmLotteryRuleService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmLotteryRules);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmLotteryRule
     *
     * @param request CmLotteryRule请求
     * @return 保存CmLotteryRule响应
     */
    @Override
    public CmLotteryRuleResponse addCmLotteryRule(CmLotteryRuleRequest request) {
        CmLotteryRuleResponse response = new CmLotteryRuleResponse();
        try {
            CmLotteryRuleEntity entity = request.getEntity();
            cmLotteryRuleService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmLotteryRule通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmLotteryRule响应
     */
    @Override
    public CmLotteryRuleResponse deleteCmLotteryRuleById(Integer id) {
        CmLotteryRuleResponse response = new CmLotteryRuleResponse();
        try {
            cmLotteryRuleService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmLotteryRule
     *
     * @param request 修改CmLotteryRule请求
     * @return 修改CmLotteryRule响应
     */
    @Override
    public CmLotteryRuleResponse updateCmLotteryRule(CmLotteryRuleRequest request) {
        CmLotteryRuleResponse response = new CmLotteryRuleResponse();
        try {
            cmLotteryRuleService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmLotteryRule
     *
     * @param id 唯一标识
     * @return 通过ID获取CmLotteryRule响应
     */
    @Override
    public CmLotteryRuleResponse getCmLotteryRuleById(Integer id) {
        CmLotteryRuleResponse response = new CmLotteryRuleResponse();
        try {
            CmLotteryRuleEntity entity = cmLotteryRuleService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
