/**
 * Description: CmInviteRecordWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-10-15 上午 09:33:17
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-10-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmInviteRecordEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmInviteRecordListRequest;
import com.house365.ws.beans.request.CmInviteRecordRequest;
import com.house365.ws.beans.response.CmInviteRecordListResponse;
import com.house365.ws.beans.response.CmInviteRecordResponse;
import com.house365.ws.interfaces.server.ICmInviteRecord;
import com.house365.ws.service.interfaces.ICmInviteRecordService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

//import org.house365.core.support.QueryParams;

/**
 * CmInviteRecordWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-10-15
 * @see
 * @since 1.0
 */
@Service("cmInviteRecord")
public class CmInviteRecordImpl implements ICmInviteRecord {
    /**
     * 日志记录器
     */
    private static final Logger logger = LoggerFactory.getLogger(CmInviteRecordImpl.class);

    /**
     * CmInviteRecord服务对象
     */
    @Autowired
    private ICmInviteRecordService<CmInviteRecordEntity> cmInviteRecordService;

    /**
     * CmInviteRecord列表查询
     *
     * @param request CmInviteRecord列表查询请求
     * @return CmInviteRecord列表查询响应
     */
    @Override
    public CmInviteRecordListResponse getCmInviteRecordList(CmInviteRecordListRequest request) {
        CmInviteRecordListResponse response = new CmInviteRecordListResponse();
        try {
            QueryParams<CmInviteRecordEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            List<CmInviteRecordEntity> cmInviteRecords = cmInviteRecordService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmInviteRecords);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmInviteRecord
     *
     * @param request CmInviteRecord请求
     * @return 保存CmInviteRecord响应
     */
    @Override
    public CmInviteRecordResponse addCmInviteRecord(CmInviteRecordRequest request) {
        CmInviteRecordResponse response = new CmInviteRecordResponse();
        try {
            CmInviteRecordEntity entity = request.getEntity();
            cmInviteRecordService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmInviteRecord通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmInviteRecord响应
     */
    @Override
    public CmInviteRecordResponse deleteCmInviteRecordById(Integer id) {
        CmInviteRecordResponse response = new CmInviteRecordResponse();
        try {
            cmInviteRecordService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmInviteRecord
     *
     * @param request 修改CmInviteRecord请求
     * @return 修改CmInviteRecord响应
     */
    @Override
    public CmInviteRecordResponse updateCmInviteRecord(CmInviteRecordRequest request) {
        CmInviteRecordResponse response = new CmInviteRecordResponse();
        try {
            cmInviteRecordService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmInviteRecord
     *
     * @param id 唯一标识
     * @return 通过ID获取CmInviteRecord响应
     */
    @Override
    public CmInviteRecordResponse getCmInviteRecordById(Integer id) {
        CmInviteRecordResponse response = new CmInviteRecordResponse();
        try {
            CmInviteRecordEntity entity = cmInviteRecordService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
