/**
 * Description: CmHouseWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:14
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmHouseEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmHouseListRequest;
import com.house365.ws.beans.request.CmHouseRequest;
import com.house365.ws.beans.response.CmHouseListResponse;
import com.house365.ws.beans.response.CmHouseResponse;
import com.house365.ws.interfaces.server.ICmHouse;
import com.house365.ws.service.interfaces.ICmHouseService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmHouseWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Service("cmHouse")
public class CmHouseImpl implements ICmHouse {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmHouseImpl.class);

    /**
     * CmHouse服务对象
     */
    @Autowired
    private ICmHouseService<CmHouseEntity> cmHouseService;

    /**
     * CmHouse列表查询
     *
     * @param request CmHouse列表查询请求
     * @return CmHouse列表查询响应
     */
    @Override
    public CmHouseListResponse getCmHouseList(CmHouseListRequest request) {
        CmHouseListResponse response = new CmHouseListResponse();
        try {
            QueryParams<CmHouseEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            List<CmHouseEntity> cmHouses = cmHouseService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmHouses);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmHouse
     *
     * @param request CmHouse请求
     * @return 保存CmHouse响应
     */
    @Override
    public CmHouseResponse addCmHouse(CmHouseRequest request) {
        CmHouseResponse response = new CmHouseResponse();
        try {
            CmHouseEntity entity = request.getEntity();
            cmHouseService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmHouse通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmHouse响应
     */
    @Override
    public CmHouseResponse deleteCmHouseById(Integer id) {
        CmHouseResponse response = new CmHouseResponse();
        try {
            cmHouseService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmHouse
     *
     * @param request 修改CmHouse请求
     * @return 修改CmHouse响应
     */
    @Override
    public CmHouseResponse updateCmHouse(CmHouseRequest request) {
        CmHouseResponse response = new CmHouseResponse();
        try {
            cmHouseService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmHouse
     *
     * @param id 唯一标识
     * @return 通过ID获取CmHouse响应
     */
    @Override
    public CmHouseResponse getCmHouseById(Integer id) {
        CmHouseResponse response = new CmHouseResponse();
        try {
            CmHouseEntity entity = cmHouseService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    public CmHouseResponse increaseComment(Integer id) {
        CmHouseResponse response = new CmHouseResponse();
        try {
            cmHouseService.increaseComment(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
