/**
 * Description: CmHouseCommentReplyWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-11 上午 09:31:50
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-11   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.beust.jcommander.internal.Lists;
import com.house365.beans.entity.CmHouseCommentEntity;
import com.house365.beans.entity.CmHouseCommentReplyEntity;
import com.house365.beans.entity.CmUserEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.beans.request.CmHouseCommentReplyListRequest;
import com.house365.ws.beans.request.CmHouseCommentReplyRequest;
import com.house365.ws.beans.response.CmHouseCommentReplyListResponse;
import com.house365.ws.beans.response.CmHouseCommentReplyResponse;
import com.house365.ws.interfaces.server.ICmHouseCommentReply;
import com.house365.ws.service.interfaces.ICmHouseCommentReplyService;
import com.house365.ws.service.interfaces.ICmHouseCommentService;
import com.house365.ws.service.interfaces.ICmUserService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * CmHouseCommentReplyWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-11
 * @see
 * @since 1.0
 */
@Service("cmHouseCommentReply")
public class CmHouseCommentReplyImpl implements ICmHouseCommentReply {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmHouseCommentReplyImpl.class);

    /**
     * CmHouseCommentReply服务对象
     */
    @Autowired
    private ICmHouseCommentReplyService<CmHouseCommentReplyEntity> cmHouseCommentReplyService;

    @Autowired
    private ICmHouseCommentService cmHouseCommentService;
    @Autowired
    private ICmUserService<CmUserEntity> cmUserService;

    /**
     * CmHouseCommentReply列表查询
     *
     * @param request CmHouseCommentReply列表查询请求
     * @return CmHouseCommentReply列表查询响应
     */
    @Override
    public CmHouseCommentReplyListResponse getCmHouseCommentReplyList(CmHouseCommentReplyListRequest request) {
        CmHouseCommentReplyListResponse response = new CmHouseCommentReplyListResponse();
        try {
            QueryParams<CmHouseCommentReplyEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<CmHouseCommentReplyEntity> cmHouseCommentReplys = cmHouseCommentReplyService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmHouseCommentReplys);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmHouseCommentReply
     *
     * @param request CmHouseCommentReply请求
     * @return 保存CmHouseCommentReply响应
     */
    @Override
    public CmHouseCommentReplyResponse addCmHouseCommentReply(CmHouseCommentReplyRequest request) {
        CmHouseCommentReplyResponse response = new CmHouseCommentReplyResponse();
        try {
            CmHouseCommentReplyEntity entity = request.getEntity();
            cmHouseCommentReplyService.save(entity);

            CmHouseCommentEntity houseCommentEntity = (CmHouseCommentEntity) cmHouseCommentService.getById(request.getEntity().getCommentId());
            //回复数量加1
            CmUserEntity commentUser = cmUserService.getById(houseCommentEntity.getCriticId());
            int unreadReplyCount = commentUser.getUnreadReply() + 1;
            commentUser.setUnreadReply(unreadReplyCount);
            cmUserService.update(commentUser);
            //清除楼盘评论缓存
            cmHouseCommentService.removeCache(houseCommentEntity.getHouseId());
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmHouseCommentReply通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmHouseCommentReply响应
     */
    @Override
    public CmHouseCommentReplyResponse deleteCmHouseCommentReplyById(Integer id) {
        CmHouseCommentReplyResponse response = new CmHouseCommentReplyResponse();
        try {
            cmHouseCommentReplyService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmHouseCommentReply
     *
     * @param request 修改CmHouseCommentReply请求
     * @return 修改CmHouseCommentReply响应
     */
    @Override
    public CmHouseCommentReplyResponse updateCmHouseCommentReply(CmHouseCommentReplyRequest request) {
        CmHouseCommentReplyResponse response = new CmHouseCommentReplyResponse();
        try {
            cmHouseCommentReplyService.update(request.getEntity());
            CmHouseCommentEntity houseCommentEntity = (CmHouseCommentEntity) cmHouseCommentService.getById(request.getEntity().getCommentId());
            //清除楼盘评论缓存
            cmHouseCommentService.removeCache(houseCommentEntity.getHouseId());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmHouseCommentReply
     *
     * @param id 唯一标识
     * @return 通过ID获取CmHouseCommentReply响应
     */
    @Override
    public CmHouseCommentReplyResponse getCmHouseCommentReplyById(Integer id) {
        CmHouseCommentReplyResponse response = new CmHouseCommentReplyResponse();
        try {
            CmHouseCommentReplyEntity entity = cmHouseCommentReplyService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    @Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = {Exception.class})
    public House365RestResponse checkHouseComment(String commentIds, String op) throws Exception {
        House365RestResponse restResponse = new House365RestResponse();

        List<String> ids = new ArrayList<>();

        if (commentIds.contains(",")) {
            ids = Lists.newArrayList(commentIds.split(","));
        } else {
            ids.add(commentIds);
        }

        Map<String, CmHouseCommentEntity> houseEntityMap = new HashMap<>();

        for (String cid : ids) {
            CmHouseCommentReplyResponse response = getCmHouseCommentReplyById(Integer.valueOf(cid));

            if (null != response.getEntity()) {
                CmHouseCommentReplyEntity cmHouseCommentEntity = response.getEntity();

                if ("pass".equalsIgnoreCase(op) && cmHouseCommentEntity.getCheckStatus() != 1) {
                    cmHouseCommentEntity.setCheckStatus(1);

                    CmHouseCommentEntity houseEntity = null;
                    if (houseEntityMap.containsKey(cmHouseCommentEntity.getCommentId())) {
                        houseEntity = houseEntityMap.get(cmHouseCommentEntity.getCommentId());
                    } else {
                        houseEntity = (CmHouseCommentEntity) cmHouseCommentService.getById(
                                cmHouseCommentEntity.getCommentId());
                    }

                    Integer commentAmount = houseEntity.getCommentAmount();
                    houseEntity.setCommentAmount(commentAmount + 1);
                    cmHouseCommentService.update(houseEntity);

                } else if ("forbid".equalsIgnoreCase(
                        op) && cmHouseCommentEntity.getCheckStatus() != 2 && cmHouseCommentEntity.getCheckStatus() != 1) {
                    //已审核和未通过的不处理
                    cmHouseCommentEntity.setCheckStatus(2);
                }

                //save after add credit , because checkstatus will be check
                CmHouseCommentReplyRequest commentRequest = new CmHouseCommentReplyRequest();
                commentRequest.setEntity(cmHouseCommentEntity);
                updateCmHouseCommentReply(commentRequest);
            }

        }

        restResponse.setResult("1");
        restResponse.setMsg("success");
        return restResponse;
    }

    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
