/**
 * Description: CmDictionaryWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-08-30 下午 13:46:00
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-08-30   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmDictionaryEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmDictionaryListRequest;
import com.house365.ws.beans.request.CmDictionaryRequest;
import com.house365.ws.beans.response.CmDictionaryListResponse;
import com.house365.ws.beans.response.CmDictionaryResponse;
import com.house365.ws.interfaces.server.ICmDictionary;
import com.house365.ws.service.interfaces.ICmDictionaryService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmDictionaryWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-08-30
 * @see
 * @since 1.0
 */
@Service("cmDictionary")
public class CmDictionaryImpl implements ICmDictionary {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmDictionaryImpl.class);

    /**
     * CmDictionary服务对象
     */
    @Autowired
    private ICmDictionaryService<CmDictionaryEntity> cmDictionaryService;

    /**
     * CmDictionary列表查询
     *
     * @param request CmDictionary列表查询请求
     * @return CmDictionary列表查询响应
     */
    @Override
    public CmDictionaryListResponse getCmDictionaryList(CmDictionaryListRequest request) {
        CmDictionaryListResponse response = new CmDictionaryListResponse();
        try {
            QueryParams<CmDictionaryEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<CmDictionaryEntity> cmDictionarys = cmDictionaryService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmDictionarys);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmDictionary
     *
     * @param request CmDictionary请求
     * @return 保存CmDictionary响应
     */
    @Override
    public CmDictionaryResponse addCmDictionary(CmDictionaryRequest request) {
        CmDictionaryResponse response = new CmDictionaryResponse();
        try {
            CmDictionaryEntity entity = request.getEntity();
            cmDictionaryService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmDictionary通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmDictionary响应
     */
    @Override
    public CmDictionaryResponse deleteCmDictionaryById(Integer id) {
        CmDictionaryResponse response = new CmDictionaryResponse();
        try {
            cmDictionaryService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmDictionary
     *
     * @param request 修改CmDictionary请求
     * @return 修改CmDictionary响应
     */
    @Override
    public CmDictionaryResponse updateCmDictionary(CmDictionaryRequest request) {
        CmDictionaryResponse response = new CmDictionaryResponse();
        try {
            cmDictionaryService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmDictionary
     *
     * @param id 唯一标识
     * @return 通过ID获取CmDictionary响应
     */
    @Override
    public CmDictionaryResponse getCmDictionaryById(Integer id) {
        CmDictionaryResponse response = new CmDictionaryResponse();
        try {
            CmDictionaryEntity entity = cmDictionaryService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
