/**
 * Description: CmDeliveryAddressWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:12
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmDeliveryAddressEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmDeliveryAddressListRequest;
import com.house365.ws.beans.request.CmDeliveryAddressRequest;
import com.house365.ws.beans.response.CmDeliveryAddressListResponse;
import com.house365.ws.beans.response.CmDeliveryAddressResponse;
import com.house365.ws.interfaces.server.ICmDeliveryAddress;
import com.house365.ws.service.interfaces.ICmDeliveryAddressService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmDeliveryAddressWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Service("cmDeliveryAddress")
public class CmDeliveryAddressImpl implements ICmDeliveryAddress {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmDeliveryAddressImpl.class);

    /**
     * CmDeliveryAddress服务对象
     */
    @Autowired
    private ICmDeliveryAddressService<CmDeliveryAddressEntity> cmDeliveryAddressService;

    /**
     * CmDeliveryAddress列表查询
     *
     * @param request
     *            CmDeliveryAddress列表查询请求
     * @return CmDeliveryAddress列表查询响应
     */
    @Override
    public CmDeliveryAddressListResponse getCmDeliveryAddressList(CmDeliveryAddressListRequest request) {
        CmDeliveryAddressListResponse response = new CmDeliveryAddressListResponse();
        try {
            QueryParams<CmDeliveryAddressEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            List<CmDeliveryAddressEntity> cmDeliveryAddresss = cmDeliveryAddressService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmDeliveryAddresss);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmDeliveryAddress
     *
     * @param request
     *            CmDeliveryAddress请求
     * @return 保存CmDeliveryAddress响应
     */
    @Override
    public CmDeliveryAddressResponse addCmDeliveryAddress(CmDeliveryAddressRequest request) {
        CmDeliveryAddressResponse response = new CmDeliveryAddressResponse();
        try {
            CmDeliveryAddressEntity entity = request.getEntity();
            cmDeliveryAddressService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmDeliveryAddress通过唯一标识
     *
     * @param id
     *            唯一标识
     * @return 删除CmDeliveryAddress响应
     */
    @Override
    public CmDeliveryAddressResponse deleteCmDeliveryAddressById(Integer id) {
        CmDeliveryAddressResponse response = new CmDeliveryAddressResponse();
        try {
            cmDeliveryAddressService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmDeliveryAddress
     *
     * @param request
     *            修改CmDeliveryAddress请求
     * @return 修改CmDeliveryAddress响应
     */
    @Override
    public CmDeliveryAddressResponse updateCmDeliveryAddress(CmDeliveryAddressRequest request) {
        CmDeliveryAddressResponse response = new CmDeliveryAddressResponse();
        try {
            cmDeliveryAddressService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmDeliveryAddress
     *
     * @param id
     *            唯一标识
     * @return 通过ID获取CmDeliveryAddress响应
     */
    @Override
    public CmDeliveryAddressResponse getCmDeliveryAddressById(Integer id) {
        CmDeliveryAddressResponse response = new CmDeliveryAddressResponse();
        try {
            CmDeliveryAddressEntity entity = cmDeliveryAddressService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
