/**
 * Description: CmCreditAddRecordWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:08
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmCreditAddRecordEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmCreditAddRecordListRequest;
import com.house365.ws.beans.request.CmCreditAddRecordRequest;
import com.house365.ws.beans.response.CmCreditAddRecordListResponse;
import com.house365.ws.beans.response.CmCreditAddRecordResponse;
import com.house365.ws.interfaces.server.ICmCreditAddRecord;
import com.house365.ws.service.interfaces.ICmCreditAddRecordService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmCreditAddRecordWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Service("cmCreditAddRecord")
public class CmCreditAddRecordImpl implements ICmCreditAddRecord {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmCreditAddRecordImpl.class);

    /**
     * CmCreditAddRecord服务对象
     */
    @Autowired
    private ICmCreditAddRecordService<CmCreditAddRecordEntity> cmCreditAddRecordService;

    /**
     * CmCreditAddRecord列表查询
     *
     * @param request CmCreditAddRecord列表查询请求
     * @return CmCreditAddRecord列表查询响应
     */
    @Override
    public CmCreditAddRecordListResponse getCmCreditAddRecordList(CmCreditAddRecordListRequest request) {
        CmCreditAddRecordListResponse response = new CmCreditAddRecordListResponse();
        try {
            QueryParams<CmCreditAddRecordEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            List<CmCreditAddRecordEntity> cmCreditAddRecords = cmCreditAddRecordService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmCreditAddRecords);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmCreditAddRecord
     *
     * @param request CmCreditAddRecord请求
     * @return 保存CmCreditAddRecord响应
     */
    @Override
    public CmCreditAddRecordResponse addCmCreditAddRecord(CmCreditAddRecordRequest request) {
        CmCreditAddRecordResponse response = new CmCreditAddRecordResponse();
        try {
            CmCreditAddRecordEntity entity = request.getEntity();
            cmCreditAddRecordService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmCreditAddRecord通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmCreditAddRecord响应
     */
    @Override
    public CmCreditAddRecordResponse deleteCmCreditAddRecordById(Integer id) {
        CmCreditAddRecordResponse response = new CmCreditAddRecordResponse();
        try {
            cmCreditAddRecordService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmCreditAddRecord
     *
     * @param request 修改CmCreditAddRecord请求
     * @return 修改CmCreditAddRecord响应
     */
    @Override
    public CmCreditAddRecordResponse updateCmCreditAddRecord(CmCreditAddRecordRequest request) {
        CmCreditAddRecordResponse response = new CmCreditAddRecordResponse();
        try {
            cmCreditAddRecordService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmCreditAddRecord
     *
     * @param id 唯一标识
     * @return 通过ID获取CmCreditAddRecord响应
     */
    @Override
    public CmCreditAddRecordResponse getCmCreditAddRecordById(Integer id) {
        CmCreditAddRecordResponse response = new CmCreditAddRecordResponse();
        try {
            CmCreditAddRecordEntity entity = cmCreditAddRecordService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
