/**
 * Description: CmCommentReportWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-14 上午 09:19:21
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmCommentReportEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmCommentReportListRequest;
import com.house365.ws.beans.request.CmCommentReportRequest;
import com.house365.ws.beans.response.CmCommentReportListResponse;
import com.house365.ws.beans.response.CmCommentReportResponse;
import com.house365.ws.interfaces.server.ICmCommentReport;
import com.house365.ws.service.interfaces.ICmCommentReportService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmCommentReportWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-14
 * @see
 * @since 1.0
 */
@Service("cmCommentReport")
public class CmCommentReportImpl implements ICmCommentReport {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmCommentReportImpl.class);

    /**
     * CmCommentReport服务对象
     */
    @Autowired
    private ICmCommentReportService<CmCommentReportEntity> cmCommentReportService;

    /**
     * CmCommentReport列表查询
     *
     * @param request CmCommentReport列表查询请求
     * @return CmCommentReport列表查询响应
     */
    @Override
    public CmCommentReportListResponse getCmCommentReportList(CmCommentReportListRequest request) {
        CmCommentReportListResponse response = new CmCommentReportListResponse();
        try {
            QueryParams<CmCommentReportEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<CmCommentReportEntity> cmCommentReports = cmCommentReportService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmCommentReports);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmCommentReport
     *
     * @param request CmCommentReport请求
     * @return 保存CmCommentReport响应
     */
    @Override
    public CmCommentReportResponse addCmCommentReport(CmCommentReportRequest request) {
        CmCommentReportResponse response = new CmCommentReportResponse();
        try {
            CmCommentReportEntity entity = request.getEntity();
            cmCommentReportService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmCommentReport通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmCommentReport响应
     */
    @Override
    public CmCommentReportResponse deleteCmCommentReportById(Integer id) {
        CmCommentReportResponse response = new CmCommentReportResponse();
        try {
            cmCommentReportService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmCommentReport
     *
     * @param request 修改CmCommentReport请求
     * @return 修改CmCommentReport响应
     */
    @Override
    public CmCommentReportResponse updateCmCommentReport(CmCommentReportRequest request) {
        CmCommentReportResponse response = new CmCommentReportResponse();
        try {
            cmCommentReportService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmCommentReport
     *
     * @param id 唯一标识
     * @return 通过ID获取CmCommentReport响应
     */
    @Override
    public CmCommentReportResponse getCmCommentReportById(Integer id) {
        CmCommentReportResponse response = new CmCommentReportResponse();
        try {
            CmCommentReportEntity entity = cmCommentReportService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    public Integer deleteCommentReport(String id, String isNoTalk, String isIgnored) {
        return cmCommentReportService.tranDeleteCommentReport(id, isNoTalk, isIgnored);
    }

    /**
     * 以下均为自动生成
     */
    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }

}
