/**
 * Description: CmBrokerCommentWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:06
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmBrokerCommentEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmBrokerCommentListRequest;
import com.house365.ws.beans.request.CmBrokerCommentRequest;
import com.house365.ws.beans.response.CmBrokerCommentListResponse;
import com.house365.ws.beans.response.CmBrokerCommentResponse;
import com.house365.ws.interfaces.server.ICmBrokerComment;
import com.house365.ws.service.interfaces.ICmBrokerCommentService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmBrokerCommentWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Service("cmBrokerComment")
public class CmBrokerCommentImpl implements ICmBrokerComment {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmBrokerCommentImpl.class);

    /**
     * CmBrokerComment服务对象
     */
    @Autowired
    private ICmBrokerCommentService<CmBrokerCommentEntity> cmBrokerCommentService;

    /**
     * CmBrokerComment列表查询
     *
     * @param request CmBrokerComment列表查询请求
     * @return CmBrokerComment列表查询响应
     */
    @Override
    public CmBrokerCommentListResponse getCmBrokerCommentList(CmBrokerCommentListRequest request) {
        CmBrokerCommentListResponse response = new CmBrokerCommentListResponse();
        try {
            QueryParams<CmBrokerCommentEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            List<CmBrokerCommentEntity> cmBrokerComments = cmBrokerCommentService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmBrokerComments);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmBrokerComment
     *
     * @param request CmBrokerComment请求
     * @return 保存CmBrokerComment响应
     */
    @Override
    public CmBrokerCommentResponse addCmBrokerComment(CmBrokerCommentRequest request) {
        CmBrokerCommentResponse response = new CmBrokerCommentResponse();
        try {
            CmBrokerCommentEntity entity = request.getEntity();
            cmBrokerCommentService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmBrokerComment通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmBrokerComment响应
     */
    @Override
    public CmBrokerCommentResponse deleteCmBrokerCommentById(Integer id) {
        CmBrokerCommentResponse response = new CmBrokerCommentResponse();
        try {
            cmBrokerCommentService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmBrokerComment
     *
     * @param request 修改CmBrokerComment请求
     * @return 修改CmBrokerComment响应
     */
    @Override
    public CmBrokerCommentResponse updateCmBrokerComment(CmBrokerCommentRequest request) {
        CmBrokerCommentResponse response = new CmBrokerCommentResponse();
        try {
            cmBrokerCommentService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmBrokerComment
     *
     * @param id 唯一标识
     * @return 通过ID获取CmBrokerComment响应
     */
    @Override
    public CmBrokerCommentResponse getCmBrokerCommentById(Integer id) {
        CmBrokerCommentResponse response = new CmBrokerCommentResponse();
        try {
            CmBrokerCommentEntity entity = cmBrokerCommentService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    public Integer deleteBroker(String id, String isNoTalk) {
        return cmBrokerCommentService.tranDeleteBroker(id, isNoTalk);
    }

    /**
     * 以下均为自动生成
     */
    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }

}
