/**
 * Description: CmAssessScoreWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-12-29 上午 11:12:25
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-12-29   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmAssessScoreEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmAssessScoreListRequest;
import com.house365.ws.beans.request.CmAssessScoreRequest;
import com.house365.ws.beans.response.CmAssessScoreListResponse;
import com.house365.ws.beans.response.CmAssessScoreResponse;
import com.house365.ws.interfaces.server.ICmAssessScore;
import com.house365.ws.service.interfaces.ICmAssessScoreService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmAssessScoreWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-12-29
 * @see
 * @since 1.0
 */
@Service("cmAssessScore")
public class CmAssessScoreImpl implements ICmAssessScore {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmAssessScoreImpl.class);

    /**
     * CmAssessScore服务对象
     */
    @Autowired
    private ICmAssessScoreService<CmAssessScoreEntity> cmAssessScoreService;

    /**
     * CmAssessScore列表查询
     *
     * @param request CmAssessScore列表查询请求
     * @return CmAssessScore列表查询响应
     */
    @Override
    public CmAssessScoreListResponse getCmAssessScoreList(CmAssessScoreListRequest request) {
        CmAssessScoreListResponse response = new CmAssessScoreListResponse();
        try {
            QueryParams<CmAssessScoreEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<CmAssessScoreEntity> cmAssessScores = cmAssessScoreService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmAssessScores);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmAssessScore
     *
     * @param request CmAssessScore请求
     * @return 保存CmAssessScore响应
     */
    @Override
    public CmAssessScoreResponse addCmAssessScore(CmAssessScoreRequest request) {
        CmAssessScoreResponse response = new CmAssessScoreResponse();
        try {
            CmAssessScoreEntity entity = request.getEntity();
            cmAssessScoreService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmAssessScore通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmAssessScore响应
     */
    @Override
    public CmAssessScoreResponse deleteCmAssessScoreById(Integer id) {
        CmAssessScoreResponse response = new CmAssessScoreResponse();
        try {
            cmAssessScoreService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmAssessScore
     *
     * @param request 修改CmAssessScore请求
     * @return 修改CmAssessScore响应
     */
    @Override
    public CmAssessScoreResponse updateCmAssessScore(CmAssessScoreRequest request) {
        CmAssessScoreResponse response = new CmAssessScoreResponse();
        try {
            cmAssessScoreService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmAssessScore
     *
     * @param id 唯一标识
     * @return 通过ID获取CmAssessScore响应
     */
    @Override
    public CmAssessScoreResponse getCmAssessScoreById(Integer id) {
        CmAssessScoreResponse response = new CmAssessScoreResponse();
        try {
            CmAssessScoreEntity entity = cmAssessScoreService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
